"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemComments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../../utils/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/item_comments/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionItemComments = exports.ExceptionItemComments = /*#__PURE__*/(0, _react.memo)(function ExceptionItemComments({
  exceptionItemComments,
  newCommentValue,
  accordionTitle,
  initialIsOpen = false,
  newCommentOnChange,
  setCommentError
}) {
  const [errorExists, setErrorExists] = (0, _react.useState)(false);
  const [shouldShowComments, setShouldShowComments] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const avatarStyles = (0, _css.css)({
    'margin-right': euiTheme.size.s
  });
  const accordionStyles = (0, _css.css)({
    padding: `${euiTheme.size.m} 0`
  });
  const currentUser = (0, _kibana.useCurrentUser)();
  const fullName = currentUser === null || currentUser === void 0 ? void 0 : currentUser.fullName;
  const userName = currentUser === null || currentUser === void 0 ? void 0 : currentUser.username;
  const userEmail = currentUser === null || currentUser === void 0 ? void 0 : currentUser.email;
  const avatarName = (0, _react.useMemo)(() => {
    if (fullName && fullName.length > 0) {
      return fullName;
    }

    // Did email second because for cloud users, username is a uuid,
    // so favor using name or email prior to using the cloud generated id
    if (userEmail && userEmail.length > 0) {
      return userEmail;
    }
    return userName && userName.length > 0 ? userName : i18n.UNKNOWN_AVATAR_NAME;
  }, [fullName, userEmail, userName]);
  (0, _react.useEffect)(() => {
    setCommentError(errorExists);
  }, [errorExists, setCommentError]);
  const handleOnChange = (0, _react.useCallback)(event => {
    newCommentOnChange(event.target.value);
    setErrorExists(event.target.value.length > _constants.MAX_COMMENT_LENGTH);
  }, [newCommentOnChange]);
  const handleTriggerOnClick = (0, _react.useCallback)(isOpen => {
    setShouldShowComments(isOpen);
  }, []);
  const commentsAccordionTitle = (0, _react.useMemo)(() => {
    if (exceptionItemComments && exceptionItemComments.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        "data-test-subj": "ExceptionItemCommentsAccordionButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 9
        }
      }, !shouldShowComments ? i18n.COMMENTS_SHOW(exceptionItemComments.length) : i18n.COMMENTS_HIDE(exceptionItemComments.length));
    } else {
      return null;
    }
  }, [exceptionItemComments, shouldShowComments]);
  const formattedComments = (0, _react.useMemo)(() => {
    if (exceptionItemComments && exceptionItemComments.length > 0) {
      return (0, _helpers.getFormattedComments)(exceptionItemComments);
    } else {
      return [];
    }
  }, [exceptionItemComments]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: initialIsOpen && !!newCommentValue,
    id: 'add-exception-comments-accordion',
    buttonClassName: accordionStyles,
    buttonContent: accordionTitle !== null && accordionTitle !== void 0 ? accordionTitle : commentsAccordionTitle,
    "data-test-subj": "exceptionItemCommentsAccordion",
    onToggle: isOpen => handleTriggerOnClick(isOpen),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    comments: formattedComments,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    className: avatarStyles,
    name: avatarName,
    size: "l",
    "data-test-subj": "exceptionItemCommentAvatar",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: i18n.COMMENT_MAX_LENGTH_ERROR(_constants.MAX_COMMENT_LENGTH),
    isInvalid: errorExists,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    isInvalid: errorExists,
    placeholder: i18n.ADD_COMMENT_PLACEHOLDER,
    "aria-label": "Comment Input",
    value: newCommentValue,
    onChange: handleOnChange,
    fullWidth: true,
    "data-test-subj": "newExceptionItemCommentTextArea",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }))))));
});