"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToRulesOrLists = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_to_rules_options = require("../add_to_rules_options");
var _add_to_lists_options = require("../add_to_lists_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/add_exception_to_rule_or_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionsAddToRulesOrListsComponent = ({
  rules,
  isBulkAction,
  selectedRadioOption,
  onListSelectionChange,
  onRuleSelectionChange,
  onRadioChange
}) => {
  const isSingleRule = (0, _react.useMemo)(() => rules != null && rules.length === 1, [rules]);

  /*
   * Determine what shared lists to display as selectable options for adding the exception item to:
   * - if dealing with a single rule - show any shared exception lists it has attached
   * - if dealing with multiple rules - show only shared exception lists that are common
   * across all of the rules
   */
  const sharedLists = (0, _react.useMemo)(() => {
    var _rules$0$exceptions_l, _rules$0$exceptions_l2, _rules$map;
    if (rules == null) return [];
    if (rules.length === 1) return (_rules$0$exceptions_l = (_rules$0$exceptions_l2 = rules[0].exceptions_list) === null || _rules$0$exceptions_l2 === void 0 ? void 0 : _rules$0$exceptions_l2.filter(list => list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION)) !== null && _rules$0$exceptions_l !== void 0 ? _rules$0$exceptions_l : [];
    const lists = (_rules$map = rules === null || rules === void 0 ? void 0 : rules.map(rule => rule.exceptions_list != null ? rule.exceptions_list : [])) !== null && _rules$map !== void 0 ? _rules$map : [];
    lists.sort((a, b) => {
      return a.length - b.length;
    });
    const shortestArrOfLists = lists.shift();
    if (shortestArrOfLists == null || !shortestArrOfLists.length) return [];
    return shortestArrOfLists.filter(exceptionListInfo => lists.every(l => l.some(({
      id
    }) => exceptionListInfo.id === id))).filter(list => list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION);
  }, [rules]);
  const rulesCount = (0, _react.useMemo)(() => rules != null ? rules.length : 0, [rules]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    "data-test-subj": "exceptionItemAddToRuleOrListSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, i18n.ADD_TO_LISTS_SECTION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_rules_options.ExceptionsAddToRulesOptions, {
    possibleRules: rules,
    isSingleRule: isSingleRule,
    isBulkAction: isBulkAction,
    selectedRadioOption: selectedRadioOption,
    onRuleSelectionChange: onRuleSelectionChange,
    onRadioChange: onRadioChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_lists_options.ExceptionsAddToListsOptions, {
    rulesCount: rulesCount,
    selectedRadioOption: selectedRadioOption,
    sharedLists: sharedLists,
    onListsSelectionChange: onListSelectionChange,
    onRadioChange: onRadioChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
const ExceptionsAddToRulesOrLists = exports.ExceptionsAddToRulesOrLists = /*#__PURE__*/_react.default.memo(ExceptionsAddToRulesOrListsComponent);
ExceptionsAddToRulesOrLists.displayName = 'ExceptionsAddToRulesOrLists';