"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exceptionItemCommentsAccordion = exports.OS_WINDOWS = exports.OS_MAC = exports.OS_LINUX = exports.EXCEPTION_ITEM_UPDATED_LABEL = exports.EXCEPTION_ITEM_META_BY = exports.EXCEPTION_ITEM_EXPIRES_LABEL = exports.EXCEPTION_ITEM_EXPIRED_LABEL = exports.EXCEPTION_ITEM_EDIT_BUTTON = exports.EXCEPTION_ITEM_DELETE_BUTTON = exports.EXCEPTION_ITEM_CREATED_LABEL = exports.ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON = exports.ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON = exports.CONDITION_OS = exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = exports.CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NOT_IN_LIST = exports.CONDITION_OPERATOR_TYPE_NESTED = exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_MATCH = exports.CONDITION_OPERATOR_TYPE_LIST = exports.CONDITION_OPERATOR_TYPE_EXISTS = exports.CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST = exports.CONDITION_AND = exports.AFFECTED_RULES = exports.AFFECTED_LIST = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCEPTION_ITEM_EDIT_BUTTON = exports.EXCEPTION_ITEM_EDIT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.editItemButton', {
  defaultMessage: 'Edit rule exception'
});
const EXCEPTION_ITEM_DELETE_BUTTON = exports.EXCEPTION_ITEM_DELETE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.deleteItemButton', {
  defaultMessage: 'Delete rule exception'
});
const ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON = exports.ENDPOINT_EXCEPTION_ITEM_EDIT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.endpoint.editItemButton', {
  defaultMessage: 'Edit endpoint exception'
});
const ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON = exports.ENDPOINT_EXCEPTION_ITEM_DELETE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.endpoint.deleteItemButton', {
  defaultMessage: 'Delete endpoint exception'
});
const EXCEPTION_ITEM_CREATED_LABEL = exports.EXCEPTION_ITEM_CREATED_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.createdLabel', {
  defaultMessage: 'Created'
});
const EXCEPTION_ITEM_UPDATED_LABEL = exports.EXCEPTION_ITEM_UPDATED_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.updatedLabel', {
  defaultMessage: 'Updated'
});
const EXCEPTION_ITEM_EXPIRES_LABEL = exports.EXCEPTION_ITEM_EXPIRES_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.expiresLabel', {
  defaultMessage: 'Expires at'
});
const EXCEPTION_ITEM_EXPIRED_LABEL = exports.EXCEPTION_ITEM_EXPIRED_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.expiredLabel', {
  defaultMessage: 'Expired at'
});
const EXCEPTION_ITEM_META_BY = exports.EXCEPTION_ITEM_META_BY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.metaDetailsBy', {
  defaultMessage: 'by'
});
const exceptionItemCommentsAccordion = comments => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.showCommentsLabel', {
  values: {
    comments
  },
  defaultMessage: 'Show {comments, plural, =1 {comment} other {comments}} ({comments})'
});
exports.exceptionItemCommentsAccordion = exceptionItemCommentsAccordion;
const CONDITION_OPERATOR_TYPE_MATCH = exports.CONDITION_OPERATOR_TYPE_MATCH = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchOperator', {
  defaultMessage: 'IS'
});
const CONDITION_OPERATOR_TYPE_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchOperator.not', {
  defaultMessage: 'IS NOT'
});
const CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.wildcardMatchesOperator', {
  defaultMessage: 'MATCHES'
});
const CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_WILDCARD_DOES_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.wildcardDoesNotMatchOperator', {
  defaultMessage: 'DOES NOT MATCH'
});
const CONDITION_OPERATOR_TYPE_NESTED = exports.CONDITION_OPERATOR_TYPE_NESTED = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.nestedOperator', {
  defaultMessage: 'has'
});
const CONDITION_OPERATOR_TYPE_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchAnyOperator', {
  defaultMessage: 'is one of'
});
const CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.matchAnyOperator.not', {
  defaultMessage: 'is not one of'
});
const CONDITION_OPERATOR_TYPE_EXISTS = exports.CONDITION_OPERATOR_TYPE_EXISTS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.existsOperator', {
  defaultMessage: 'exists'
});
const CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST = exports.CONDITION_OPERATOR_TYPE_DOES_NOT_EXIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.existsOperator.not', {
  defaultMessage: 'does not exist'
});
const CONDITION_OPERATOR_TYPE_LIST = exports.CONDITION_OPERATOR_TYPE_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.listOperator', {
  defaultMessage: 'included in'
});
const CONDITION_OPERATOR_TYPE_NOT_IN_LIST = exports.CONDITION_OPERATOR_TYPE_NOT_IN_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.listOperator.not', {
  defaultMessage: 'is not included in'
});
const CONDITION_AND = exports.CONDITION_AND = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.and', {
  defaultMessage: 'AND'
});
const CONDITION_OS = exports.CONDITION_OS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.os', {
  defaultMessage: 'OS'
});
const OS_WINDOWS = exports.OS_WINDOWS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.windows', {
  defaultMessage: 'Windows'
});
const OS_LINUX = exports.OS_LINUX = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.linux', {
  defaultMessage: 'Linux'
});
const OS_MAC = exports.OS_MAC = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.conditions.macos', {
  defaultMessage: 'Mac'
});
const AFFECTED_RULES = numRules => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.affectedRules', {
  values: {
    numRules
  },
  defaultMessage: 'Affects {numRules} {numRules, plural, =1 {rule} other {rules}}'
});
exports.AFFECTED_RULES = AFFECTED_RULES;
const AFFECTED_LIST = exports.AFFECTED_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.exceptionItem.affectedList', {
  defaultMessage: 'Affects shared list'
});