"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddNewExceptionItems = void 0;
var _react = require("react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_create_update_exception = require("../../logic/use_create_update_exception");
var _use_add_rule_exception = require("../../logic/use_add_rule_exception");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for adding new exception items from flyout
 *
 */
const useAddNewExceptionItems = () => {
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const [isAddRuleExceptionLoading, addRuleExceptions] = (0, _use_add_rule_exception.useAddRuleDefaultException)();
  const [isAddingExceptions, addSharedExceptions] = (0, _use_create_update_exception.useCreateOrUpdateException)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const addNewExceptionsRef = (0, _react.useRef)(null);
  const areRuleDefaultItems = (0, _react.useCallback)(items => {
    return items.every(item => _securitysolutionIoTsListTypes.createRuleExceptionListItemSchema.is(item));
  }, []);
  const areSharedListItems = (0, _react.useCallback)(items => {
    return items.every(item => _securitysolutionIoTsListTypes.exceptionListItemSchema.is(item) || _securitysolutionIoTsListTypes.createExceptionListItemSchema.is(item));
  }, []);
  (0, _react.useEffect)(() => {
    const abortCtrl = new AbortController();
    const addNewExceptions = async ({
      itemsToAdd,
      listType,
      selectedRulesToAddTo,
      addToRules,
      addToSharedLists,
      sharedLists
    }) => {
      try {
        let result = [];
        setIsLoading(true);
        if (addToRules && addRuleExceptions != null && listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && areRuleDefaultItems(itemsToAdd)) {
          result = await addRuleExceptions(itemsToAdd, selectedRulesToAddTo);
          const ruleNames = selectedRulesToAddTo.map(({
            name
          }) => name).join(', ');
          addSuccess({
            title: i18n.ADD_RULE_EXCEPTION_SUCCESS_TITLE,
            text: i18n.ADD_RULE_EXCEPTION_SUCCESS_TEXT(ruleNames)
          });
        } else if ((listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT || addToSharedLists) && addSharedExceptions != null && areSharedListItems(itemsToAdd)) {
          result = await addSharedExceptions(itemsToAdd);
          const sharedListNames = sharedLists.map(({
            name
          }) => name);
          const title = (0, _helpers.getSuccessToastTitle)(listType);
          const text = (0, _helpers.getSuccessToastText)(listType, sharedListNames);
          addSuccess({
            title,
            text
          });
        }
        setIsLoading(false);
        return result;
      } catch (e) {
        setIsLoading(false);
        addError(e, {
          title: i18n.SUBMIT_ERROR_TITLE
        });
        throw e;
      }
    };
    addNewExceptionsRef.current = addNewExceptions;
    return () => {
      abortCtrl.abort();
    };
  }, [addSuccess, addError, addWarning, addRuleExceptions, addSharedExceptions, areRuleDefaultItems, areSharedListItems]);
  return [isLoading || isAddingExceptions || isAddRuleExceptionLoading, addNewExceptionsRef.current];
};
exports.useAddNewExceptionItems = useAddNewExceptionItems;