"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistentAlertSuppressionState = usePersistentAlertSuppressionState;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _utils = require("../../../../../common/detection_engine/utils");
var _shared_imports = require("../../../../shared_imports");
var _threshold_alert_suppression_edit = require("../../../rule_creation/components/threshold_alert_suppression_edit");
var _alert_suppression_edit = require("../../../rule_creation/components/alert_suppression_edit");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePersistentAlertSuppressionState({
  form
}) {
  const [{
    ruleType,
    [_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED]: thresholdAlertSuppressionEnabled,
    [_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: suppressionFields,
    [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME]: suppressionDurationType,
    [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]: suppressionDuration,
    [_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME]: suppressionMissingFieldsStrategy
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['ruleType', _threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED, _alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME, _alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME, `${_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME}.${_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_VALUE_FIELD_NAME}`, `${_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME}.${_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_UNIT_FIELD_NAME}`, _alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME]
  });
  const previousRuleType = (0, _usePrevious.default)(ruleType);
  (0, _react.useEffect)(() => {
    if (!ruleType || ruleType === previousRuleType) {
      return;
    }
    form.updateFieldValues({
      [_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED]: thresholdAlertSuppressionEnabled,
      [_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: suppressionFields,
      ...((0, _utils.isThresholdRule)(ruleType) ? {
        [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME]: _types.AlertSuppressionDurationType.PerTimePeriod
      } : {
        [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME]: suppressionDurationType
      }),
      [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]: suppressionDuration,
      [_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME]: suppressionMissingFieldsStrategy
    });
  }, [form, ruleType, previousRuleType, thresholdAlertSuppressionEnabled, suppressionFields, suppressionDurationType, suppressionDuration, suppressionMissingFieldsStrategy]);
}