"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrations = void 0;
var _reactQuery = require("@tanstack/react-query");
var _fleet_integrations = require("../../../fleet_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE = 60000;
const useIntegrations = ({
  skip = false
} = {}) => {
  return (0, _reactQuery.useQuery)(['integrations'], async ({
    signal
  }) => {
    var _response$integration;
    const response = await _fleet_integrations.fleetIntegrationsApi.fetchAllIntegrations({
      signal
    });
    return (_response$integration = response.integrations) !== null && _response$integration !== void 0 ? _response$integration : [];
  }, {
    keepPreviousData: true,
    staleTime: ONE_MINUTE * 5,
    enabled: !skip
  });
};
exports.useIntegrations = useIntegrations;