"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowCheckBox = exports.HeaderCheckBox = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/control_columns/checkbox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RowCheckBox = ({
  eventId,
  onRowSelected,
  checked,
  ariaRowindex,
  columnValues,
  disabled,
  loadingEventIds
}) => {
  const handleSelectEvent = (0, _react.useCallback)(event => {
    if (!disabled) {
      onRowSelected({
        eventIds: [eventId],
        isSelected: event.currentTarget.checked
      });
    }
  }, [eventId, onRowSelected, disabled]);
  return loadingEventIds.includes(eventId) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "event-loader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": `select-event select-event-${eventId}`,
    id: eventId,
    checked: checked && !disabled,
    disabled: disabled,
    onChange: handleSelectEvent,
    "aria-label": i18n.CHECKBOX_FOR_ROW({
      ariaRowindex,
      columnValues,
      checked
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.RowCheckBox = RowCheckBox;
const HeaderCheckBox = ({
  onSelectAll,
  isSelectAllChecked
}) => {
  const handleSelectPageChange = (0, _react.useCallback)(event => {
    onSelectAll({
      isSelected: event.currentTarget.checked
    });
  }, [onSelectAll]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "select-all-events",
    id: "select-all-events",
    checked: isSelectAllChecked,
    onChange: handleSelectPageChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.HeaderCheckBox = HeaderCheckBox;