"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopAssetsQuery = void 0;
var _constants = require("../../constants");
var _fetch_utils = require("../fetch_utils");
var _add_empty_data_filter = require("../../utils/add_empty_data_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTopAssetsQuery = ({
  query,
  sort
}, indexPattern) => {
  var _query$bool$filter, _query$bool, _query$bool$should, _query$bool2, _query$bool$must, _query$bool3, _query$bool$must_not, _query$bool4;
  if (!indexPattern) {
    throw new Error('Index pattern is required');
  }
  return {
    size: 0,
    index: indexPattern,
    aggs: {
      entityType: {
        terms: {
          field: _constants.ASSET_FIELDS.ENTITY_TYPE,
          order: {
            entityId: 'desc'
          },
          size: 10
        },
        aggs: {
          entitySubType: {
            terms: {
              field: _constants.ASSET_FIELDS.ENTITY_SUB_TYPE,
              order: {
                entityId: 'desc'
              },
              size: 10,
              missing: 'Uncategorized'
            },
            aggs: {
              entityId: {
                value_count: {
                  field: _constants.ASSET_FIELDS.ENTITY_ID
                }
              }
            }
          },
          entityId: {
            value_count: {
              field: _constants.ASSET_FIELDS.ENTITY_ID
            }
          }
        }
      }
    },
    query: {
      ...query,
      bool: {
        ...(query === null || query === void 0 ? void 0 : query.bool),
        filter: [...((_query$bool$filter = query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) !== null && _query$bool$filter !== void 0 ? _query$bool$filter : [])],
        should: [...((_query$bool$should = query === null || query === void 0 ? void 0 : (_query$bool2 = query.bool) === null || _query$bool2 === void 0 ? void 0 : _query$bool2.should) !== null && _query$bool$should !== void 0 ? _query$bool$should : [])],
        must: [...((_query$bool$must = query === null || query === void 0 ? void 0 : (_query$bool3 = query.bool) === null || _query$bool3 === void 0 ? void 0 : _query$bool3.must) !== null && _query$bool$must !== void 0 ? _query$bool$must : [])],
        must_not: (0, _add_empty_data_filter.addEmptyDataFilterQuery)([...((_query$bool$must_not = query === null || query === void 0 ? void 0 : (_query$bool4 = query.bool) === null || _query$bool4 === void 0 ? void 0 : _query$bool4.must_not) !== null && _query$bool$must_not !== void 0 ? _query$bool$must_not : [])])
      }
    },
    sort: (0, _fetch_utils.getMultiFieldsSort)(sort),
    ignore_unavailable: true
  };
};
exports.getTopAssetsQuery = getTopAssetsQuery;