"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMonitoredPrivilegedUserCsvRow = void 0;
var E = _interopRequireWildcard(require("fp-ts/Either"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseMonitoredPrivilegedUserCsvRow = row => {
  if (row.length > 2 || row.length === 0) {
    return E.left(expectedColumnsError(row.length));
  }
  const [username, label] = row;
  if (!username) {
    return E.left(missingUserNameError());
  }
  return E.right({
    username,
    label
  });
};
exports.parseMonitoredPrivilegedUserCsvRow = parseMonitoredPrivilegedUserCsvRow;
const expectedColumnsError = rowLength => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.monitoring.privilegedUsers.csvUpload.expectedColumnsError', {
  defaultMessage: 'Expected 1 or 2 columns, got {rowLength}',
  values: {
    rowLength
  }
});
const missingUserNameError = () => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.monitoring.privilegedUsers.csvUpload.missingUserNameError', {
  defaultMessage: 'Missing user name'
});