"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firstLastSeenResponseSchema = exports.firstLastSeenRequestOptionsSchema = void 0;
var _zod = require("@kbn/zod");
var _order = require("../model/order");
var _request_basic_options = require("../model/request_basic_options");
var _inspect = require("../model/inspect");
var _factory_query_type = require("../model/factory_query_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const firstLastSeenRequestOptionsSchema = exports.firstLastSeenRequestOptionsSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  order: _order.order,
  field: _zod.z.string(),
  value: _zod.z.string(),
  factoryQueryType: _zod.z.literal(_factory_query_type.FirstLastSeenQuery)
});
const firstLastSeenResponseSchema = exports.firstLastSeenResponseSchema = _zod.z.object({
  firstSeen: _zod.z.string().nullable(),
  lastSeen: _zod.z.string().nullable(),
  inspect: _inspect.inspect
}).partial();