"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewRuleUpgradeSort = exports.ReviewRuleUpgradeRequestBody = void 0;
var _zod = require("@kbn/zod");
var _model = require("../../model");
var _rule_management = require("../../rule_management");
var _review_prebuilt_rules_upgrade_filter = require("../common/review_prebuilt_rules_upgrade_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReviewRuleUpgradeSort = exports.ReviewRuleUpgradeSort = _zod.z.object({
  /**
   * Field to sort by
   */
  field: _rule_management.FindRulesSortField.optional(),
  /**
   * Sort order
   */
  order: _model.SortOrder.optional()
});
const ReviewRuleUpgradeRequestBody = exports.ReviewRuleUpgradeRequestBody = _zod.z.object({
  filter: _review_prebuilt_rules_upgrade_filter.ReviewPrebuiltRuleUpgradeFilter.optional(),
  sort: ReviewRuleUpgradeSort.optional(),
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Rules per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
}).nullable();