"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeleteCasesSubFeature = exports.getCasesSettingsCasesSubFeature = exports.getCasesReopenCaseSubFeature = exports.getCasesAssignUsersCasesSubFeature = exports.getCasesAddCommentsCasesSubFeature = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeleteCasesSubFeature = ({
  apiTags,
  uiCapabilities,
  savedObjects
}) => ({
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureName', {
    defaultMessage: 'Delete'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: apiTags.default.delete,
      id: 'cases_delete',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureDetails', {
        defaultMessage: 'Delete cases and comments'
      }),
      includeIn: 'all',
      savedObject: {
        all: [...savedObjects.files],
        read: [...savedObjects.files]
      },
      cases: {
        delete: [_constants.APP_ID]
      },
      ui: uiCapabilities.default.delete
    }]
  }]
});
exports.getDeleteCasesSubFeature = getDeleteCasesSubFeature;
const getCasesSettingsCasesSubFeature = ({
  uiCapabilities,
  savedObjects
}) => ({
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureName', {
    defaultMessage: 'Case settings'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      id: 'cases_settings',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureDetails', {
        defaultMessage: 'Edit case settings'
      }),
      includeIn: 'all',
      savedObject: {
        all: [...savedObjects.files],
        read: [...savedObjects.files]
      },
      cases: {
        settings: [_constants.APP_ID]
      },
      ui: uiCapabilities.default.settings
    }]
  }]
});
exports.getCasesSettingsCasesSubFeature = getCasesSettingsCasesSubFeature;
const getCasesAddCommentsCasesSubFeature = ({
  apiTags,
  uiCapabilities,
  savedObjects
}) => ({
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.addCommentsSubFeatureName', {
    defaultMessage: 'Create comments & attachments'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: apiTags.default.createComment,
      id: 'create_comment',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.addCommentsSubFeatureDetails', {
        defaultMessage: 'Add comments to cases'
      }),
      includeIn: 'all',
      savedObject: {
        all: [...savedObjects.files],
        read: [...savedObjects.files]
      },
      cases: {
        createComment: [_constants.APP_ID]
      },
      ui: uiCapabilities.default.createComment
    }]
  }]
});
exports.getCasesAddCommentsCasesSubFeature = getCasesAddCommentsCasesSubFeature;
const getCasesReopenCaseSubFeature = ({
  uiCapabilities
}) => ({
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.reopenCaseSubFeatureName', {
    defaultMessage: 'Re-open'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      id: 'case_reopen',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.reopenCaseSubFeatureDetails', {
        defaultMessage: 'Re-open closed cases'
      }),
      includeIn: 'all',
      savedObject: {
        all: [],
        read: []
      },
      cases: {
        reopenCase: [_constants.APP_ID]
      },
      ui: uiCapabilities.default.reopenCase
    }]
  }]
});
exports.getCasesReopenCaseSubFeature = getCasesReopenCaseSubFeature;
const getCasesAssignUsersCasesSubFeature = ({
  uiCapabilities
}) => ({
  name: _i18n.i18n.translate('securitySolutionPackages.features.assignUsersSubFeatureName', {
    defaultMessage: 'Assign users'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      id: 'cases_assign',
      name: _i18n.i18n.translate('securitySolutionPackages.features.assignUsersSubFeatureName', {
        defaultMessage: 'Assign users to cases'
      }),
      includeIn: 'all',
      savedObject: {
        all: [],
        read: []
      },
      cases: {
        assign: [_constants.APP_ID]
      },
      ui: uiCapabilities.default.assignCase
    }]
  }]
});
exports.getCasesAssignUsersCasesSubFeature = getCasesAssignUsersCasesSubFeature;