"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnauthorizedResponseHttpInterceptor = void 0;
var _constants = require("../../common/constants");
var _types = require("../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UnauthorizedResponseHttpInterceptor {
  constructor(sessionExpired, anonymousPaths) {
    this.sessionExpired = sessionExpired;
    this.anonymousPaths = anonymousPaths;
  }
  responseError(httpErrorResponse, controller) {
    if (this.anonymousPaths.isAnonymous(window.location.pathname)) {
      return;
    }

    // if the request was omitting credentials it's to an anonymous endpoint
    // (for example to login) and we don't wish to ever redirect
    if (httpErrorResponse.request.credentials === 'omit') {
      return;
    }

    // if we happen to not have a response, for example if there is no
    // network connectivity, we don't do anything
    const {
      response
    } = httpErrorResponse;
    if (!response) {
      return;
    }
    if (response.status === 401) {
      const reason = response.headers.get(_constants.SESSION_ERROR_REASON_HEADER);
      this.sessionExpired.logout(reason === _types.LogoutReason.SESSION_EXPIRED || reason === _types.LogoutReason.CONCURRENCY_LIMIT ? reason : _types.LogoutReason.AUTHENTICATION_ERROR);
      controller.halt();
    }
  }
}
exports.UnauthorizedResponseHttpInterceptor = UnauthorizedResponseHttpInterceptor;