"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roleMappingsManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _readonly_badge = require("../badges/readonly_badge");
var _url_utils = require("../url_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/role_mappings_management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const roleMappingsManagementApp = exports.roleMappingsManagementApp = Object.freeze({
  id: 'role_mappings',
  create({
    getStartServices
  }) {
    const title = _i18n.i18n.translate('xpack.security.management.roleMappingsTitle', {
      defaultMessage: 'Role Mappings'
    });
    return {
      id: this.id,
      order: 40,
      title,
      async mount({
        element,
        setBreadcrumbs,
        history
      }) {
        const [[core], {
          RoleMappingsGridPage
        }, {
          EditRoleMappingPage
        }, {
          RoleMappingsAPIClient
        }, {
          RolesAPIClient
        }, {
          SecurityFeaturesAPIClient
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./role_mappings_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_role_mapping'))), Promise.resolve().then(() => _interopRequireWildcard(require('./role_mappings_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('../roles'))), Promise.resolve().then(() => _interopRequireWildcard(require('../security_features')))]);
        core.chrome.docTitle.change(title);
        const roleMappingsAPIClient = new RoleMappingsAPIClient(core.http);
        const securityFeaturesAPIClient = new SecurityFeaturesAPIClient(core.http);
        const EditRoleMappingsPageWithBreadcrumbs = ({
          action
        }) => {
          const {
            name
          } = (0, _reactRouterDom.useParams)();

          // Additional decoding is a workaround for a bug in react-router's version of the `history` module.
          // See https://github.com/elastic/kibana/issues/82440
          const decodedName = name ? (0, _url_utils.tryDecodeURIComponent)(name) : undefined;
          const breadcrumbObj = action === 'edit' && name && decodedName ? {
            text: decodedName,
            href: `/edit/${encodeURIComponent(name)}`
          } : {
            text: _i18n.i18n.translate('xpack.security.roleMappings.createBreadcrumb', {
              defaultMessage: 'Create'
            })
          };
          return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
            text: breadcrumbObj.text,
            href: breadcrumbObj.href,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 81,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(EditRoleMappingPage, {
            action: action,
            name: decodedName,
            roleMappingsAPI: roleMappingsAPIClient,
            securityFeaturesAPI: securityFeaturesAPIClient,
            rolesAPIClient: new RolesAPIClient(core.http),
            notifications: core.notifications,
            docLinks: core.docLinks,
            history: history,
            readOnly: !core.application.capabilities.role_mappings.save,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 82,
              columnNumber: 15
            }
          }));
        };
        (0, _reactDom.render)(core.rendering.addContext(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: core,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
          history: history,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
          "data-test-subj": "readOnlyBadge",
          featureId: "role_mappings",
          tooltip: _i18n.i18n.translate('xpack.security.management.roleMappings.readonlyTooltip', {
            defaultMessage: 'Unable to create or edit role mappings'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(core.chrome, setBreadcrumbs),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: title,
          href: "/",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/', ''],
          exact: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(RoleMappingsGridPage, {
          notifications: core.notifications,
          rolesAPIClient: new RolesAPIClient(core.http),
          roleMappingsAPI: roleMappingsAPIClient,
          securityFeaturesAPI: securityFeaturesAPIClient,
          docLinks: core.docLinks,
          history: history,
          navigateToApp: core.application.navigateToApp,
          readOnly: !core.application.capabilities.role_mappings.save,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 23
          }
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:name?",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(EditRoleMappingsPageWithBreadcrumbs, {
          action: "edit",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 23
          }
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/clone/:name",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(EditRoleMappingsPageWithBreadcrumbs, {
          action: "clone",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 23
          }
        }))))))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});