"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchPlaygroundFeatureFlag = void 0;
var _feature_flags = require("../utils/feature_flags");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchPlaygroundFeatureFlag = () => {
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  return uiSettings ? (0, _feature_flags.isSearchModeEnabled)(uiSettings) : false;
};
exports.useSearchPlaygroundFeatureFlag = useSearchPlaygroundFeatureFlag;