"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePlaygroundsList = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("../../common");
var _types = require("../types");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePlaygroundsList = ({
  page,
  sortField,
  sortOrder
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: [_common.SearchPlaygroundQueryKeys.PlaygroundsList, page, sortField, sortOrder],
    queryFn: async () => http.get(_types.APIRoutes.GET_PLAYGROUNDS, {
      query: {
        page,
        sortField,
        sortOrder
      },
      version: _common.ROUTE_VERSIONS.v1
    })
  });
};
exports.usePlaygroundsList = usePlaygroundsList;