"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _discoverUtils = require("@kbn/discover-utils");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/search_mode/result_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResultList = ({
  executionTime,
  searchResults,
  mappings,
  pagination,
  onPaginationChange
}) => {
  const {
    services: {
      data
    }
  } = (0, _use_kibana.useKibana)();
  const [dataView, setDataView] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    data.dataViews.getDefaultDataView().then(d => setDataView(d));
  }, [data]);
  const [flyoutDocId, setFlyoutDocId] = (0, _react.useState)(undefined);
  const documentMeta = (0, _searchIndexDocuments.pageToPagination)(pagination);
  const hit = flyoutDocId && (0, _discoverUtils.buildDataTableRecord)(searchResults.find(item => item._id === flyoutDocId));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.DocumentList, {
    executionTime: executionTime,
    dataTelemetryIdPrefix: "result-list",
    docs: searchResults,
    docsPerPage: 10,
    isLoading: false,
    mappings: mappings,
    meta: documentMeta,
    onPaginate: onPaginationChange,
    onDocumentClick: searchHit => setFlyoutDocId(searchHit._id),
    resultProps: {
      showScore: true,
      compactCard: false,
      defaultVisibleFields: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), flyoutDocId && dataView && hit && /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerFlyout, {
    services: {},
    onClose: () => setFlyoutDocId(undefined),
    isEsqlQuery: false,
    columns: [],
    hit: hit,
    dataView: dataView,
    onAddColumn: () => {},
    onRemoveColumn: () => {},
    setExpandedDoc: () => {},
    flyoutType: "overlay",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }));
};
exports.ResultList = ResultList;