"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDocumentRoutes = registerDocumentRoutes;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _routes = require("../../common/routes");
var _documents = require("../lib/documents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerDocumentRoutes(router, logger) {
  router.delete({
    path: _routes.INDEX_DOCUMENT_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {
      params: _configSchema.schema.object({
        indexName: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      })
    },
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    const core = await context.core;
    const client = core.elasticsearch.client.asCurrentUser;
    const {
      indexName,
      id
    } = request.params;
    try {
      await (0, _documents.deleteDocument)(client, logger, indexName, id);
      return response.ok();
    } catch (e) {
      var _e$meta, _e$meta2;
      return response.customError({
        statusCode: e !== null && e !== void 0 && e.meta && (_e$meta = e.meta) !== null && _e$meta !== void 0 && _e$meta.statusCode ? (_e$meta2 = e.meta) === null || _e$meta2 === void 0 ? void 0 : _e$meta2.statusCode : 500,
        body: {
          message: _i18n.i18n.translate('xpack.searchIndices.server.deleteDocument.errorMessage', {
            defaultMessage: 'Failed to delete document'
          })
        }
      });
    }
  });
}