"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearch = void 0;
var _common = require("@kbn/data-plugin/common");
var _saved_searches_utils = require("../../../common/saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSavedSearch = async (savedSearchId, deps) => {
  var _attributes$kibanaSav, _attributes$kibanaSav2;
  const savedSearch = await deps.savedObjects.get('search', savedSearchId);
  const [{
    attributes
  }] = savedSearch.attributes.tabs;
  const parsedSearchSourceJSON = (0, _common.parseSearchSourceJSON)((_attributes$kibanaSav = (_attributes$kibanaSav2 = attributes.kibanaSavedObjectMeta) === null || _attributes$kibanaSav2 === void 0 ? void 0 : _attributes$kibanaSav2.searchSourceJSON) !== null && _attributes$kibanaSav !== void 0 ? _attributes$kibanaSav : '{}');
  const searchSourceValues = (0, _common.injectReferences)(parsedSearchSourceJSON, savedSearch.references);
  return (0, _saved_searches_utils.fromSavedSearchAttributes)(savedSearchId, savedSearch.attributes, undefined, await deps.searchSourceStart.create(searchSourceValues), Boolean(savedSearch.managed));
};
exports.getSavedSearch = getSavedSearch;