"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchSavedObject = exports.getSavedSearch = exports.convertToSavedSearch = void 0;
var _common = require("@kbn/data-plugin/common");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _saved_searches_utils = require("./saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// these won't exist in on server

const getSavedSearchUrlConflictMessage = async json => _i18n.i18n.translate('savedSearch.legacyURLConflict.errorMessage', {
  defaultMessage: `This Discover session has the same URL as a legacy alias. Disable the alias to resolve this error: {json}`,
  values: {
    json
  }
});
const getSearchSavedObject = async (savedSearchId, {
  spaces,
  getSavedSrch,
  handleGetSavedSrchError
}) => {
  try {
    const so = await getSavedSrch(savedSearchId);
    if (so.meta.outcome === 'conflict') {
      var _await$spaces$getActi;
      throw new Error(await getSavedSearchUrlConflictMessage(JSON.stringify({
        targetType: _.SavedSearchType,
        sourceId: savedSearchId,
        // front end only
        targetSpace: (_await$spaces$getActi = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace())) === null || _await$spaces$getActi === void 0 ? void 0 : _await$spaces$getActi.id
      })));
    }
    return so;
  } catch (e) {
    handleGetSavedSrchError === null || handleGetSavedSrchError === void 0 ? void 0 : handleGetSavedSrchError(e, savedSearchId);
    throw e;
  }
};
exports.getSearchSavedObject = getSearchSavedObject;
const convertToSavedSearch = async ({
  savedSearchId,
  attributes,
  references,
  sharingSavedObjectProps,
  managed
}, {
  searchSourceCreate,
  savedObjectsTagging
}, serialized) => {
  var _tab$attributes$kiban, _tab$attributes$kiban2;
  const [tab] = attributes.tabs;
  const parsedSearchSourceJSON = (0, _common.parseSearchSourceJSON)((_tab$attributes$kiban = (_tab$attributes$kiban2 = tab.attributes.kibanaSavedObjectMeta) === null || _tab$attributes$kiban2 === void 0 ? void 0 : _tab$attributes$kiban2.searchSourceJSON) !== null && _tab$attributes$kiban !== void 0 ? _tab$attributes$kiban : '{}');
  const searchSourceValues = (0, _common.injectReferences)(parsedSearchSourceJSON, references);

  // front end only
  const tags = savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(references) : undefined;
  const searchSource = serialized ? searchSourceValues : await searchSourceCreate(searchSourceValues);
  const returnVal = (0, _saved_searches_utils.fromSavedSearchAttributes)(savedSearchId, attributes, tags, references, searchSource, sharingSavedObjectProps, Boolean(managed), serialized);
  return returnVal;
};
exports.convertToSavedSearch = convertToSavedSearch;
const getSavedSearch = async (savedSearchId, deps, serialized) => {
  const so = await getSearchSavedObject(savedSearchId, deps);
  const savedSearch = await convertToSavedSearch({
    savedSearchId,
    attributes: so.item.attributes,
    references: so.item.references,
    sharingSavedObjectProps: so.meta,
    managed: so.item.managed
  }, deps, serialized);
  return savedSearch;
};
exports.getSavedSearch = getSavedSearch;