"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssignAction = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _assign_flyout = require("../../components/assign_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAssignAction = ({
  assignableTypes,
  assignmentService,
  tagCache,
  fetchTags,
  canceled$,
  ...startServices
}) => {
  const openFlyout = (0, _assign_flyout.getAssignFlyoutOpener)({
    ...startServices,
    tagCache,
    assignmentService,
    assignableTypes
  });
  return {
    id: 'assign',
    name: ({
      name
    }) => _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.actions.assign.title', {
      defaultMessage: 'Manage {name} assignments',
      values: {
        name
      }
    }),
    description: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.actions.assign.description', {
      defaultMessage: 'Manage assignments'
    }),
    type: 'icon',
    icon: 'tag',
    available: tag => !tag.managed,
    onClick: async tag => {
      const flyout = await openFlyout({
        tagIds: [tag.id]
      });

      // close the flyout when the action is canceled
      // this is required when the user navigates away from the page
      canceled$.pipe((0, _rxjs.takeUntil)((0, _rxjs.from)(flyout.onClose))).subscribe(() => {
        flyout.close();
      });
      await flyout.onClose;
      await fetchTags();
    },
    'data-test-subj': 'tagsTableAction-assign'
  };
};
exports.getAssignAction = getAssignAction;