"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDateHistogram = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps/step_date_histogram.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  parseEsInterval
} = _public.search.aggs;
const timeZoneOptions = _momentTimezone.default.tz.names().map(name => ({
  value: name,
  text: name
}));
class StepDateHistogram extends _react.Component {
  static getDerivedStateFromProps(props) {
    const {
      dateFields
    } = props;
    const dateHistogramFieldOptions = dateFields.map(dateField => ({
      value: dateField,
      text: dateField
    }));
    return {
      dateHistogramFieldOptions
    };
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        hasErrors
      } = this.props;
      if (!areStepErrorsVisible || !hasErrors) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components.StepError, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 321,
          columnNumber: 12
        }
      });
    });
    this.state = {
      dateHistogramFieldOptions: []
    };
  }
  renderIntervalHelpText() {
    const {
      fields
    } = this.props;
    const {
      dateHistogramInterval
    } = fields;
    let preferFixedWarning;
    try {
      const {
        value,
        unit
      } = parseEsInterval(dateHistogramInterval);
      if (value === 1) {
        switch (unit) {
          case 'd':
            preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "warning",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 82,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement("p", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 83,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningDayLabel",
              defaultMessage: "Consider using 24h instead of 1d. This allows for more flexible queries.",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 84,
                columnNumber: 19
              }
            })));
            break;
          case 'h':
            preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "warning",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 95,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement("p", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 96,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningHourLabel",
              defaultMessage: "Consider using 60m instead of 1h. This allows for more flexible queries.",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 97,
                columnNumber: 19
              }
            })));
            break;
        }
      }
      switch (unit) {
        case 'y':
          preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "warning",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 111,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 112,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningYearLabel",
            defaultMessage: "Consider using the d unit instead of y. This allows for more flexible queries.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 113,
              columnNumber: 17
            }
          })));
          break;
        case 'M':
          preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "warning",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 124,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 125,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningMonthLabel",
            defaultMessage: "Consider using the d unit instead of M. This allows for more flexible queries.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 17
            }
          })));
          break;
        case 'w':
          preferFixedWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "warning",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 137,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.preferFixedWarningWeekLabel",
            defaultMessage: "Consider using the d unit instead of w. This allows for more flexible queries.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 17
            }
          })));
          break;
      }
    } catch (error) {
      // Swallow error; the validation logic will handle it elsewhere.
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 7
      }
    }, preferFixedWarning, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepDateHistogram.fieldInterval.helpExampleLabel",
      defaultMessage: "Example sizes: 1000ms, 30s, 20m, 24h, 2d, 1w, 1M, 1y",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    })));
  }
  render() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors
    } = this.props;
    const {
      dateHistogramInterval,
      dateHistogramField,
      dateHistogramTimeZone
    } = fields;
    const {
      dateHistogramInterval: errorDateHistogramInterval,
      dateHistogramField: errorDateHistogramField,
      dateHistogramTimeZone: errorDateHistogramTimeZone
    } = fieldErrors;
    const {
      dateHistogramFieldOptions
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateDateHistogramTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepDateHistogramTitle",
      defaultMessage: "Date histogram",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "rollupJobCreateDateHistogramDocsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepDateHistogram.readDocsButtonLabel",
      defaultMessage: "Date histogram docs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 20
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogramDescription",
        defaultMessage: "Define how {link} will operate on your rollup data.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation_links.documentationLinks.aggs.date_histogram,
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 223,
              columnNumber: 25
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.stepDateHistogramDescription.aggregationsLinkLabel",
            defaultMessage: "date histogram aggregations",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 224,
              columnNumber: 27
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.sectionDataSourceDescription",
        defaultMessage: "Note that smaller time buckets take up proportionally more space.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 19
        }
      }))),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldDateFieldLabel",
        defaultMessage: "Date field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 17
        }
      }),
      error: errorDateHistogramField,
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramField),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramField),
      options: dateHistogramFieldOptions,
      value: dateHistogramField,
      onChange: e => onFieldsChange({
        dateHistogramField: e.target.value
      }),
      fullWidth: true,
      "data-test-subj": "rollupJobCreateDateFieldSelect",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldIntervalLabel",
        defaultMessage: "Time bucket size",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 17
        }
      }),
      error: errorDateHistogramInterval,
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramInterval),
      helpText: this.renderIntervalHelpText(),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: dateHistogramInterval || '',
      onChange: e => onFieldsChange({
        dateHistogramInterval: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramInterval),
      fullWidth: true,
      "data-test-subj": "rollupJobInterval",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldTimeZoneLabel",
        defaultMessage: "Time zone",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 17
        }
      }),
      error: errorDateHistogramTimeZone || '',
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramTimeZone),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      isInvalid: Boolean(areStepErrorsVisible && errorDateHistogramTimeZone),
      options: timeZoneOptions,
      value: dateHistogramTimeZone,
      onChange: e => onFieldsChange({
        dateHistogramTimeZone: e.target.value
      }),
      fullWidth: true,
      "data-test-subj": "rollupJobCreateTimeZoneSelect",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 15
      }
    })))), this.renderErrors());
  }
}
exports.StepDateHistogram = StepDateHistogram;
(0, _defineProperty2.default)(StepDateHistogram, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  hasErrors: _propTypes.default.bool.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  dateFields: _propTypes.default.array.isRequired
});