"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorCountParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _search_configuration_schema = require("../common/search_configuration_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const errorCountParamsSchema = exports.errorCountParamsSchema = _configSchema.schema.object({
  windowSize: _configSchema.schema.number({
    meta: {
      description: 'The time frame in which the errors must occur (in `windowUnit` units). Generally it should be a value higher than the rule check interval to avoid gaps in detection.'
    }
  }),
  windowUnit: _configSchema.schema.string({
    meta: {
      description: 'The type of units for the time window: minutes, hours, or days.'
    }
  }),
  threshold: _configSchema.schema.number({
    meta: {
      description: 'The number of errors, which is the threshold for alerts.'
    }
  }),
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Filter the errors coming from your application to apply the rule to a specific service.'
    }
  })),
  environment: _configSchema.schema.string({
    meta: {
      description: 'Filter the errors coming from your application to apply the rule to a specific environment.'
    }
  }),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Perform a composite aggregation against the selected fields. When any of these groups match the selected rule conditions, an alert is triggered per group.'
    }
  }))),
  errorGroupingKey: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Filter the errors coming from your application to apply the rule to a specific error grouping key, which is a hash of the stack trace and other properties.'
    }
  })),
  useKqlFilter: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'A filter in Kibana Query Language (KQL) that limits the scope of the rule.'
    }
  })),
  searchConfiguration: _configSchema.schema.maybe(_search_configuration_schema.searchConfigurationSchema)
});