"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverLink = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverLink = ({
  filters
}) => {
  var _useKibana$services$d;
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  const locator = (_useKibana$services$d = (0, _kibana.useKibana)().services.discover) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.locator;
  const [discoverUrl, setDiscoverUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getDiscoverUrl = async () => {
      if (!locator) return;
      const newUrl = await locator.getUrl({
        indexPatternId: 'logs-*',
        filters: filters.map(filter => ({
          meta: {
            index: 'logs-*',
            alias: null,
            negate: false,
            disabled: false,
            type: 'phrase',
            key: filter.key,
            params: {
              query: filter.value
            }
          },
          query: {
            match_phrase: {
              action_id: filter.value
            }
          },
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          }
        }))
      });
      setDiscoverUrl(newUrl);
    };
    getDiscoverUrl();
  }, [filters, locator]);
  const onClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event) && discoverUrl) {
      event.preventDefault();
      return navigateToUrl(discoverUrl);
    }
  }, [discoverUrl, navigateToUrl]);
  return {
    href: discoverUrl,
    onClick
  };
};
exports.useDiscoverLink = useDiscoverLink;