"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unionWithNullType = exports.stringEnum = exports.assertUnreachable = void 0;
var runtimeTypes = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This type is for typing EuiDescriptionList

const unionWithNullType = type => runtimeTypes.union([type, runtimeTypes.null]);
exports.unionWithNullType = unionWithNullType;
const stringEnum = (enumObj, enumName = 'enum') => new runtimeTypes.Type(enumName,
// @ts-expect-error upgrade typescript v4.9.5
u => Object.values(enumObj).includes(u), (u, c) =>
// @ts-expect-error upgrade typescript v4.9.5
Object.values(enumObj).includes(u) ? runtimeTypes.success(u) : runtimeTypes.failure(u, c), a => a);

/**
 * Unreachable Assertion helper for scenarios like exhaustive switches.
 * For references see: https://stackoverflow.com/questions/39419170/how-do-i-check-that-a-switch-block-is-exhaustive-in-typescript
 * This "x" should _always_ be a type of "never" and not change to "unknown" or any other type. See above link or the generic
 * concept of exhaustive checks in switch blocks.
 *
 * Optionally you can avoid the use of this by using early returns and TypeScript will clear your type checking without complaints
 * but there are situations and times where this function might still be needed.
 * @param x Unreachable field
 * @param message Message of error thrown
 */
exports.stringEnum = stringEnum;
const assertUnreachable = (x,
// This should always be a type of "never"
message = 'Unknown Field in switch statement') => {
  throw new Error(`${message}: ${x}`);
};
exports.assertUnreachable = assertUnreachable;