"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateLiveQueryResponse = exports.CreateLiveQueryRequestBody = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../model/schema/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Create Live Query Schema
 *   version: 2023-10-31
 */

const CreateLiveQueryRequestBody = exports.CreateLiveQueryRequestBody = _zod.z.object({
  /**
   * A list of agent IDs to run the query on.
   */
  agent_ids: _zod.z.array(_zod.z.string()).optional(),
  /**
   * When `true`, the query runs on all agents.
   */
  agent_all: _zod.z.boolean().optional(),
  /**
   * A list of agent platforms to run the query on.
   */
  agent_platforms: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A list of agent policy IDs to run the query on.
   */
  agent_policy_ids: _zod.z.array(_zod.z.string()).optional(),
  query: _common_attributes.QueryOrUndefined.optional(),
  queries: _common_attributes.ArrayQueries.optional(),
  saved_query_id: _common_attributes.SavedQueryIdOrUndefined.optional(),
  ecs_mapping: _common_attributes.ECSMappingOrUndefined.optional(),
  pack_id: _common_attributes.PackIdOrUndefined.optional(),
  /**
   * A list of alert IDs associated with the live query.
   */
  alert_ids: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A list of case IDs associated with the live query.
   */
  case_ids: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A list of event IDs associated with the live query.
   */
  event_ids: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Custom metadata object associated with the live query.
   */
  metadata: _zod.z.object({}).nullable().optional()
});
const CreateLiveQueryResponse = exports.CreateLiveQueryResponse = _zod.z.object({});