"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolTypeInfo = void 0;
var _definitions = require("../tool_types/definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getToolTypeInfo = definitions => {
  const typeInfos = [];
  for (const definition of definitions) {
    if ((0, _definitions.isEnabledDefinition)(definition)) {
      typeInfos.push({
        type: definition.toolType,
        create: true
      });
    }
    if ((0, _definitions.isBuiltinDefinition)(definition)) {
      typeInfos.push({
        type: definition.toolType,
        create: false
      });
    }
  }
  return typeInfos;
};
exports.getToolTypeInfo = getToolTypeInfo;