"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.A2A_SERVER_PATH = void 0;
exports.registerA2ARoutes = registerA2ARoutes;
var _configSchema = require("@kbn/config-schema");
var _nodePath = _interopRequireDefault(require("node:path"));
var _features = require("../../common/features");
var _constants = require("../../common/constants");
var _wrap_handler = require("./wrap_handler");
var _kibana_a2a_adapter = require("../utils/a2a/kibana_a2a_adapter");
var _get_kibana_url = require("../utils/get_kibana_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const A2A_SERVER_PATH = exports.A2A_SERVER_PATH = `${_constants.publicApiPath}/a2a`;
function registerA2ARoutes({
  router,
  getInternalServices,
  coreSetup,
  logger,
  pluginsSetup
}) {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });
  const getBaseUrl = () => {
    return (0, _get_kibana_url.getKibanaUrl)(coreSetup, pluginsSetup.cloud);
  };
  const a2aAdapter = new _kibana_a2a_adapter.KibanaA2AAdapter(logger, getInternalServices, getBaseUrl);
  router.versioned.get({
    path: `${A2A_SERVER_PATH}/{agentId}.json`,
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    access: 'public',
    summary: 'Get A2A agent card',
    description: 'Get agent discovery metadata in JSON format. Use this endpoint to provide agent information for A2A protocol integration and discovery.',
    options: {
      tags: ['a2a', 'oas-tag:agent builder'],
      availability: {
        stability: 'experimental',
        since: '9.2.0'
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        params: _configSchema.schema.object({
          agentId: _configSchema.schema.string({
            meta: {
              description: 'The unique identifier of the agent to get A2A metadata for.'
            }
          })
        })
      }
    },
    options: {
      oasOperationObject: () => _nodePath.default.join(__dirname, 'examples/a2a_agent_card.yaml')
    }
  }, wrapHandler(async (ctx, request, response) => {
    return await a2aAdapter.handleAgentCardRequest(request, response, request.params.agentId);
  }));
  router.versioned.post({
    path: `${A2A_SERVER_PATH}/{agentId}`,
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    },
    access: 'public',
    summary: 'Send A2A task',
    description: 'Handle A2A (Agent-to-Agent) task requests. Use this endpoint to process inter-agent communication using JSON-RPC 2.0 protocol.',
    options: {
      tags: ['a2a', 'oas-tag:agent builder'],
      xsrfRequired: false,
      availability: {
        stability: 'experimental',
        since: '9.2.0'
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        params: _configSchema.schema.object({
          agentId: _configSchema.schema.string({
            meta: {
              description: 'The unique identifier of the agent to send the A2A task to.'
            }
          })
        }),
        body: _configSchema.schema.object({}, {
          unknowns: 'allow',
          meta: {
            description: 'JSON-RPC 2.0 request payload for A2A communication.'
          }
        })
      }
    },
    options: {
      oasOperationObject: () => _nodePath.default.join(__dirname, 'examples/a2a_task.yaml')
    }
  }, wrapHandler(async (ctx, request, response) => {
    const {
      agentId
    } = request.params;
    return await a2aAdapter.handleA2ARequest(request, response, agentId);
  }));
}