"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentBuilderAccessChecker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolveValues = async promiseObject => {
  const entries = await Promise.all(Object.entries(promiseObject).map(async ([key, promise]) => [key, await promise]));
  return Object.fromEntries(entries);
};
class AgentBuilderAccessChecker {
  constructor({
    licensing,
    inference
  }) {
    (0, _defineProperty2.default)(this, "licensing", void 0);
    (0, _defineProperty2.default)(this, "inference", void 0);
    (0, _defineProperty2.default)(this, "access", null);
    this.licensing = licensing;
    this.inference = inference;
  }
  async hasRequiredLicense() {
    const license = await (0, _rxjs.firstValueFrom)(this.licensing.license$);
    return license.hasAtLeast('enterprise') && license.isActive;
  }
  async hasLlmConnector() {
    const connectors = await this.inference.getConnectors();
    return connectors.length > 0;
  }
  async initAccess() {
    if (this.access !== null) {
      return;
    }
    const accessPromise = {
      hasRequiredLicense: this.hasRequiredLicense(),
      hasLlmConnector: this.hasLlmConnector()
    };
    try {
      this.access = await resolveValues(accessPromise);
    } catch (error) {
      throw new Error('Unable to determine Agent Builder access', {
        cause: error
      });
    }
  }
  getAccess() {
    if (!this.access) {
      throw new Error('Agent Builder access was not initialized');
    }
    return this.access;
  }
}
exports.AgentBuilderAccessChecker = AgentBuilderAccessChecker;