"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolTypes = void 0;
var _reactQuery = require("@tanstack/react-query");
var _query_keys = require("../../query_keys");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToolTypes = () => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data: toolTypes,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.typeInfo,
    queryFn: () => toolsService.getToolTypes()
  });
  return {
    toolTypes,
    isLoading
  };
};
exports.useToolTypes = useToolTypes;