"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListWorkflows = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_onechat_service = require("../use_onechat_service");
var _query_keys = require("../../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useListWorkflows = () => {
  var _result$data;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const result = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.workflows.list(),
    queryFn: () => toolsService.listWorkflows({})
  });
  return {
    ...result,
    data: (_result$data = result.data) === null || _result$data === void 0 ? void 0 : _result$data.results
  };
};
exports.useListWorkflows = useListWorkflows;