"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConversationPrompt = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _use_navigation = require("../../hooks/use_navigation");
var _app_paths = require("../../utils/app_paths");
var _conversation_grid = require("./conversation_grid");
var _conversation_input_form = require("./conversation_input/conversation_input_form");
var _conversation_grid2 = require("./conversation_grid.styles");
var _doc_links = require("../../../../common/doc_links");
var _welcome_text = require("../common/welcome_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/new_conversation_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fullHeightStyles = (0, _react2.css)`
  height: 100%;
`;
const cards = [
// Create agent
{
  key: 'createAgent',
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.agentCreation.title",
    defaultMessage: "Create a new agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.agentCreation.description",
    defaultMessage: "Build a custom agent tuned to your data and workflows.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }),
  iconType: 'plus',
  link: {
    path: _app_paths.appPaths.agents.new
  }
},
// Manage agents
{
  key: 'manageAgents',
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.agentManagement.title",
    defaultMessage: "Manage agents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.agentManagement.description",
    defaultMessage: "View, edit, and organize your existing agents.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }),
  iconType: 'controls',
  link: {
    path: _app_paths.appPaths.agents.list
  }
},
// Manage tools
{
  key: 'manageTools',
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.toolManagement.title",
    defaultMessage: "Manage tools",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.toolManagement.description",
    defaultMessage: "Add, remove, or edit the tools your agents can use.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }),
  iconType: 'wrench',
  link: {
    path: _app_paths.appPaths.tools.list
  }
},
// Documentation - Get Started
{
  key: 'documentation',
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.documentation.title",
    defaultMessage: "Get started",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.welcome.quickNavigation.documentation.description",
    defaultMessage: "Learn how to start building agents and tools.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }),
  iconType: 'documentation',
  link: {
    url: _doc_links.docLinks.getStarted
  }
}];
const QuickNavigationCards = () => {
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const titleStyles = (0, _react2.css)`
    ${(0, _eui.useEuiFontSize)('s')}
    font-weight: ${euiTheme.font.weight.bold};
  `;
  const descriptionStyles = (0, _react2.css)`
    ${(0, _eui.useEuiFontSize)('xs')}
    color: ${euiTheme.colors.textSubdued};
  `;
  const iconBackgroundStyles = (0, _react2.css)`
    padding: ${euiTheme.size.s};
    background-color: ${euiTheme.colors.lightestShade};
    border-radius: ${euiTheme.border.radius.medium};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "newConversationPromptLinks",
    gutterSize: "s",
    component: "ul",
    "aria-label": "Quick navigation links",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, cards.map(({
    key,
    title,
    description,
    iconType,
    link
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: key,
      component: "li",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      "data-test-subj": "newConversationPromptLinkItem",
      hasBorder: true,
      textAlign: "left",
      title: /*#__PURE__*/_react.default.createElement("span", {
        css: titleStyles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 22
        }
      }, title),
      description: /*#__PURE__*/_react.default.createElement("span", {
        css: descriptionStyles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 28
        }
      }, description),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: iconBackgroundStyles,
        component: "span",
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 21
        }
      }))),
      href: 'url' in link ? link.url : createOnechatUrl(link.path),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    }));
  }));
};
const mainContainerStyles = (0, _react2.css)`
  grid-column: 2;
`;
const MainContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  css: mainContainerStyles,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 166,
    columnNumber: 3
  }
}, children);
const withMarginContainerStyles = (0, _react2.css)`
  grid-column: 1 / 4;
`;
const WithMarginsContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  css: withMarginContainerStyles,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 174,
    columnNumber: 3
  }
}, children);
const NewConversationPrompt = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const centerColumnWidth = (0, _conversation_grid2.useConversationGridCenterColumnWidth)();
  const inputRowHeight = `calc(${euiTheme.size.l} * 7)`;
  const gridStyles = (0, _react2.css)`
    display: grid;
    grid-template-columns: 1fr ${centerColumnWidth} 1fr;
    grid-template-rows: auto ${inputRowHeight} auto;
    row-gap: ${euiTheme.size.l};
  `;
  return /*#__PURE__*/_react.default.createElement(_conversation_grid.ConversationContentWithMargins, {
    css: fullHeightStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: gridStyles,
    "data-test-subj": "agentBuilderWelcomePage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MainContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_welcome_text.WelcomeText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(WithMarginsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_input_form.ConversationInputForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(WithMarginsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(QuickNavigationCards, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }))));
};
exports.NewConversationPrompt = NewConversationPrompt;