"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEsql = void 0;
var _inferenceTracing = require("@kbn/inference-tracing");
var _doc_base = require("@kbn/inference-plugin/server/tasks/nl_to_esql/doc_base");
var _graph = require("./graph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateEsql = async ({
  nlQuery,
  index,
  executeQuery = true,
  additionalInstructions,
  additionalContext,
  maxRetries = 3,
  model,
  esClient,
  logger,
  events
}) => {
  const docBase = await _doc_base.EsqlDocumentBase.load();
  const graph = (0, _graph.createNlToEsqlGraph)({
    model,
    esClient,
    logger,
    docBase,
    events
  });
  return (0, _inferenceTracing.withActiveInferenceSpan)('GenerateEsqlGraph', {
    attributes: {
      [_inferenceTracing.ElasticGenAIAttributes.InferenceSpanKind]: 'CHAIN'
    }
  }, async () => {
    try {
      const outState = await graph.invoke({
        nlQuery,
        target: index,
        executeQuery,
        maxRetries,
        additionalInstructions,
        additionalContext
      }, {
        recursionLimit: 25,
        tags: ['generate_esql'],
        metadata: {
          graphName: 'generate_esql'
        }
      });
      return {
        error: outState.error,
        answer: outState.answer,
        query: outState.query,
        results: outState.results
      };
    } catch (e) {
      throw new Error(`Could not generate ESQL query: ${e.message}`);
    }
  });
};
exports.generateEsql = generateEsql;