"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.useTrackMetric = useTrackMetric;
exports.useTrackPageview = useTrackPageview;
exports.useUiTracker = useUiTracker;
var _react = require("react");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Note: The usage_collection plugin will take care of sending this data to the telemetry server.
 * You can find the metrics that are collected by these hooks in Stack Telemetry.
 * Search the index `kibana-ui-counter`. You can filter for `eventName` and/or `appName`.
 */

function useUiTracker({
  app: defaultApp
} = {}) {
  var _useKibana$services, _useKibana$services$u;
  const reportUiCounter = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$u = _useKibana$services.usageCollection) === null || _useKibana$services$u === void 0 ? void 0 : _useKibana$services$u.reportUiCounter;
  const trackEvent = (0, _react.useMemo)(() => {
    return ({
      app = defaultApp,
      metric,
      metricType = _analytics.METRIC_TYPE.COUNT
    }) => {
      if (reportUiCounter) {
        reportUiCounter(app, metricType, metric);
      }
    };
  }, [defaultApp, reportUiCounter]);
  return trackEvent;
}
function useTrackMetric({
  app,
  metric,
  metricType = _analytics.METRIC_TYPE.COUNT,
  delay = 0
}, effectDependencies = []) {
  var _useKibana$services2, _useKibana$services2$;
  const reportUiCounter = (_useKibana$services2 = (0, _public.useKibana)().services) === null || _useKibana$services2 === void 0 ? void 0 : (_useKibana$services2$ = _useKibana$services2.usageCollection) === null || _useKibana$services2$ === void 0 ? void 0 : _useKibana$services2$.reportUiCounter;
  (0, _react.useEffect)(() => {
    if (!reportUiCounter) {
      // eslint-disable-next-line no-console
      console.log('usageCollection.reportUiCounter is unavailable. Ensure this is setup via <KibanaContextProvider />.');
    } else {
      let decoratedMetric = metric;
      if (delay > 0) {
        decoratedMetric += `__delayed_${delay}ms`;
      }
      const id = setTimeout(() => reportUiCounter(app, metricType, decoratedMetric), Math.max(delay, 0));
      return () => clearTimeout(id);
    }
    // the dependencies are managed externally
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, effectDependencies);
}

/**
 * useTrackPageview is a convenience wrapper for tracking a pageview
 * Its metrics will be found at:
 * stack_stats.kibana.plugins.ui_metric.{app}.pageview__{path}(__delayed_{n}ms)?
 */

function useTrackPageview({
  path,
  ...rest
}, effectDependencies = []) {
  useTrackMetric({
    ...rest,
    metric: `pageview__${path}`
  }, effectDependencies);
}