"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreVitalItem = CoreVitalItem;
exports.getCoreVitalTooltipMessage = getCoreVitalTooltipMessage;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _palette_legends = require("./palette_legends");
var _color_palette_flex_item = require("./color_palette_flex_item");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/ux/core_web_vitals/core_vital_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getCoreVitalTooltipMessage(thresholds, position, title, percentage, isCls) {
  const good = position === 0;
  const bad = position === 2;
  const average = !good && !bad;
  return _i18n.i18n.translate('xpack.observability.ux.dashboard.webVitals.palette.tooltip', {
    defaultMessage: '{percentage} % of users have {exp} experience because the {title} {isOrTakes} {moreOrLess} than {value}{averageMessage}.',
    values: {
      percentage,
      isOrTakes: isCls ? _translations.IS_LABEL : _translations.TAKES_LABEL,
      title: title === null || title === void 0 ? void 0 : title.toLowerCase(),
      exp: good ? _translations.CV_GOOD_LABEL : bad ? _translations.CV_POOR_LABEL : _translations.CV_AVERAGE_LABEL,
      moreOrLess: bad || average ? _translations.MORE_LABEL : _translations.LESS_LABEL,
      value: good || average ? thresholds.good : thresholds.bad,
      averageMessage: average ? _i18n.i18n.translate('xpack.observability.ux.coreVitals.averageMessage', {
        defaultMessage: ' and less than {bad}',
        values: {
          bad: thresholds.bad
        }
      }) : ''
    }
  });
}
function CoreVitalItem({
  loading,
  title,
  value,
  thresholds,
  ranks = [100, 0, 0],
  isCls,
  helpLabel,
  dataTestSubj
}) {
  const palette = (0, _eui.euiPaletteForStatus)(3);
  const [inFocusInd, setInFocusInd] = (0, _react.useState)(null);
  const biggestValIndex = ranks.indexOf(Math.max(...ranks));
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const colorsStatus = [colors.textSuccess, colors.textWarning, colors.textDanger];
  if (!value && !loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: title,
      isDisabled: true,
      description: _translations.NO_DATA,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": dataTestSubj,
    "aria-label": `${title} ${value}` // aria-label is required when passing a component, instead of a string, as the description
    ,
    titleSize: "s",
    title: value !== null && value !== void 0 ? value : '',
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: helpLabel,
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    })),
    isLoading: loading,
    titleColor: colorsStatus[biggestValIndex],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexStart",
    style: {
      maxWidth: 350
    },
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, palette.map((hexCode, ind) => /*#__PURE__*/_react.default.createElement(_color_palette_flex_item.ColorPaletteFlexItem, {
    hexCode: hexCode,
    key: hexCode,
    position: ind,
    inFocus: inFocusInd !== ind && inFocusInd !== null,
    percentage: ranks[ind],
    tooltip: getCoreVitalTooltipMessage(thresholds, ind, title, ranks[ind], isCls),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_palette_legends.PaletteLegends, {
    ranks: ranks,
    thresholds: thresholds,
    title: title,
    onItemHover: ind => {
      setInFocusInd(ind);
    },
    isCls: isCls,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }));
}