"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterProximalParam = void 0;
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilterProximalParam = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const searchParams = new URLSearchParams(search);
  const history = (0, _reactRouterDom.useHistory)();
  const setProximalFilterParam = proximalFilter => {
    searchParams.set('filterProximal', String(proximalFilter));
    history.replace({
      search: searchParams.toString()
    });
  };
  const filterProximal = searchParams.get('filterProximal') === 'true';
  return {
    filterProximal,
    setProximalFilterParam
  };
};
exports.useFilterProximalParam = useFilterProximalParam;