"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseButton = AddToCaseButton;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/cases-plugin/common");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _kibana_react = require("../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/add_to_case_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AddToCaseButton({
  alert,
  alertIndex,
  rule,
  setIsPopoverOpen
}) {
  var _services$cases;
  const {
    services,
    services: {
      telemetryClient
    }
  } = (0, _kibana_react.useKibana)();
  const selectCaseModal = (_services$cases = services.cases) === null || _services$cases === void 0 ? void 0 : _services$cases.hooks.useCasesAddToExistingCaseModal({
    onSuccess: ({
      updatedAt
    }) => {
      // If the case is newly created the updatedAt will be null
      // onSuccess doesn't provide a way to know if the case was created or updated
      // onCreateCaseClicked callback is NOT triggered
      const isNewCaseCreated = !updatedAt;
      telemetryClient.reportAlertAddedToCase(isNewCaseCreated, 'alertDetails.addToCaseBtn', (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) || 'unknown');
    }
  });
  const attachments = alert && rule ? [{
    alertId: (alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_UUID]) || '',
    index: alertIndex || '',
    rule: {
      id: rule.id,
      name: rule.name
    },
    type: _common.AttachmentType.alert
  }] : [];
  const handleAddToCase = () => {
    setIsPopoverOpen(false);
    selectCaseModal === null || selectCaseModal === void 0 ? void 0 : selectCaseModal.open({
      getAttachments: () => attachments
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plus",
    onClick: handleAddToCase,
    "data-test-subj": `add-to-cases-button-${rule === null || rule === void 0 ? void 0 : rule.ruleTypeId}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.addToCase', {
    defaultMessage: 'Add to case'
  })));
}