"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDisableRule = useDisableRule;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDisableRule() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const disableRule = (0, _reactQuery.useMutation)(['disableRule'], ({
    id,
    untrack
  }) => {
    const body = JSON.stringify({
      ...(untrack ? {
        untrack
      } : {})
    });
    try {
      return http.post(`/api/alerting/rule/${id}/_disable`, {
        body
      });
    } catch (e) {
      throw new Error(`Unable to parse id: ${e}`);
    }
  }, {
    onError: _err => {
      toasts.addDanger(_i18n.i18n.translate('xpack.observability.rules.disableErrorModal.errorNotification.descriptionText', {
        defaultMessage: 'Failed to disable rule'
      }));
    },
    onSuccess: (_, variables) => {
      queryClient.invalidateQueries({
        queryKey: ['fetchRule', variables.id],
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.rules.disableConfirmationModal.successNotification.descriptionText', {
        defaultMessage: 'Disabled rule'
      }));
    }
  });
  return disableRule;
}