"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchApmSuggestions = useFetchApmSuggestions;
var _reactQuery = require("@tanstack/react-query");
var _moment = _interopRequireDefault(require("moment"));
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_SUGGESTIONS = [];
function useFetchApmSuggestions({
  fieldName,
  search = '',
  serviceName = ''
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchApmSuggestions', fieldName, search, serviceName],
    queryFn: async ({
      signal
    }) => {
      try {
        const {
          terms = []
        } = await http.get('/internal/apm/suggestions', {
          query: {
            fieldName,
            start: (0, _moment.default)().subtract(2, 'days').toISOString(),
            end: (0, _moment.default)().toISOString(),
            fieldValue: search,
            ...(!!serviceName && fieldName !== 'service.name' && {
              serviceName
            })
          },
          signal
        });
        return terms;
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    suggestions: isInitialLoading ? NO_SUGGESTIONS : data !== null && data !== void 0 ? data : NO_SUGGESTIONS,
    isLoading: isInitialLoading || isLoading || isRefetching,
    isSuccess,
    isError
  };
}