"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getColumns = ({
  showRuleName
} = {
  showRuleName: false
}) => {
  const ruleNameColumn = showRuleName ? [{
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.ruleNameColumnDescription', {
      defaultMessage: 'Rule name'
    }),
    id: _ruleDataUtils.ALERT_RULE_NAME,
    initialWidth: 150
  }] : [];
  return [{
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.statusColumnDescription', {
      defaultMessage: 'Alert Status'
    }),
    id: _ruleDataUtils.ALERT_STATUS,
    initialWidth: 120
  }, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.triggeredColumnDescription', {
      defaultMessage: 'Triggered'
    }),
    id: _ruleDataUtils.ALERT_START,
    initialWidth: 190,
    schema: 'datetime'
  }, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.durationColumnDescription', {
      defaultMessage: 'Duration'
    }),
    id: _ruleDataUtils.ALERT_DURATION,
    initialWidth: 70
  }, ...ruleNameColumn, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.sourceColumnDescription', {
      defaultMessage: 'Group'
    }),
    id: _ruleDataUtils.ALERT_INSTANCE_ID,
    initialWidth: 100
  }, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.observedValueColumnDescription', {
      defaultMessage: 'Observed value'
    }),
    id: _ruleDataUtils.ALERT_EVALUATION_VALUE,
    initialWidth: 100
  }, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.thresholdColumnDescription', {
      defaultMessage: 'Threshold'
    }),
    id: _ruleDataUtils.ALERT_EVALUATION_THRESHOLD,
    initialWidth: 100
  }, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.tagsColumnDescription', {
      defaultMessage: 'Tags'
    }),
    id: _ruleDataUtils.TAGS,
    initialWidth: 150
  }, {
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.reasonColumnDescription', {
      defaultMessage: 'Reason'
    }),
    id: _ruleDataUtils.ALERT_REASON
  }];
};
exports.getColumns = getColumns;