"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedNavButton = exports.NewsfeedContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _flyout_list = require("./flyout_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/newsfeed/public/components/newsfeed_header_nav_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NewsfeedContext = exports.NewsfeedContext = /*#__PURE__*/_react.default.createContext({});
const NewsfeedNavButton = ({
  newsfeedApi,
  hasCustomBranding$,
  isServerless
}) => {
  const [flyoutVisible, setFlyoutVisible] = (0, _react.useState)(false);
  const [newsFetchResult, setNewsFetchResult] = (0, _react.useState)(null);
  const hasCustomBranding = (0, _useObservable.default)(hasCustomBranding$, false);
  const hasNew = (0, _react.useMemo)(() => {
    return newsFetchResult ? newsFetchResult.hasNew : false;
  }, [newsFetchResult]);
  const buttonRef = (0, _react.useRef)(null);
  const setButtonRef = node => buttonRef.current = node;
  (0, _react.useEffect)(() => {
    const subscription = newsfeedApi.fetchResults$.subscribe(results => {
      setNewsFetchResult(results);
    });
    return () => subscription.unsubscribe();
  }, [newsfeedApi]);
  const showFlyout = (0, _react.useCallback)(() => {
    if (newsFetchResult) {
      newsfeedApi.markAsRead(newsFetchResult.feedItems.map(item => item.hash));
    }
    setFlyoutVisible(!flyoutVisible);
  }, [newsfeedApi, newsFetchResult, flyoutVisible]);
  return /*#__PURE__*/_react.default.createElement(NewsfeedContext.Provider, {
    value: {
      setFlyoutVisible,
      newsFetchResult
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
    ref: setButtonRef,
    "data-test-subj": "newsfeed",
    "aria-controls": "keyPadMenu",
    "aria-expanded": flyoutVisible,
    "aria-haspopup": "true",
    "aria-label": hasNew ? _i18n.i18n.translate('newsfeed.headerButton.unreadAriaLabel', {
      defaultMessage: 'Newsfeed menu - unread items available'
    }) : _i18n.i18n.translate('newsfeed.headerButton.readAriaLabel', {
      defaultMessage: 'Newsfeed menu - all items read'
    }),
    notification: hasNew ? true : null,
    onClick: showFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "cheer",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })), flyoutVisible ? /*#__PURE__*/_react.default.createElement(_flyout_list.NewsfeedFlyout, {
    isServerless: isServerless,
    focusTrapProps: {
      shards: [buttonRef]
    },
    showPlainSpinner: hasCustomBranding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }) : null));
};
exports.NewsfeedNavButton = NewsfeedNavButton;