"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalState = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _history = require("history");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _legacy_shims = require("./legacy_shims");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GLOBAL_STATE_KEY = '_g';
const objectEquals = (objA, objB) => JSON.stringify(objA) === JSON.stringify(objB);
class GlobalState {
  constructor(queryService, toasts, externalState) {
    (0, _defineProperty2.default)(this, "stateSyncRef", void 0);
    (0, _defineProperty2.default)(this, "stateContainer", void 0);
    (0, _defineProperty2.default)(this, "stateStorage", void 0);
    (0, _defineProperty2.default)(this, "stateContainerChangeSub", void 0);
    (0, _defineProperty2.default)(this, "syncQueryStateWithUrlManager", void 0);
    (0, _defineProperty2.default)(this, "timefilterRef", void 0);
    (0, _defineProperty2.default)(this, "lastAssignedState", {});
    this.timefilterRef = queryService.timefilter.timefilter;
    const history = (0, _history.createHashHistory)();
    this.stateStorage = (0, _public2.createKbnUrlStateStorage)({
      useHash: false,
      history,
      ...(0, _public2.withNotifyOnErrors)(toasts)
    });
    const initialStateFromUrl = this.stateStorage.get(GLOBAL_STATE_KEY);
    this.stateContainer = (0, _public2.createStateContainer)(initialStateFromUrl, {
      set: state => (prop, value) => ({
        ...state,
        [prop]: value
      })
    });
    this.stateSyncRef = (0, _public2.syncState)({
      storageKey: GLOBAL_STATE_KEY,
      stateContainer: this.stateContainer,
      stateStorage: this.stateStorage
    });
    this.stateContainerChangeSub = this.stateContainer.state$.subscribe(() => {
      this.lastAssignedState = this.getState();

      // TODO: check if this is not needed after https://github.com/elastic/kibana/pull/109132 is merged
      if (_legacy_shims.Legacy.isInitializated()) {
        _legacy_shims.Legacy.shims.breadcrumbs.update();
      }
      this.syncExternalState(externalState);
    });
    this.syncQueryStateWithUrlManager = (0, _public.syncQueryStateWithUrl)(queryService, this.stateStorage);
    this.stateSyncRef.start();
    this.lastAssignedState = this.getState();
  }
  syncExternalState(externalState) {
    const currentState = this.stateContainer.get();
    for (const key in currentState) {
      if ({
        save: 1,
        time: 1,
        refreshInterval: 1,
        filters: 1
      }[key]) {
        continue;
      }
      if (currentState[key] !== externalState[key]) {
        externalState[key] = currentState[key];
      }
    }
  }
  setState(state) {
    const currentAppState = this.getState();
    const newAppState = {
      ...currentAppState,
      ...state
    };
    if (state && objectEquals(newAppState, currentAppState)) {
      return;
    }
    const newState = {
      ...newAppState,
      refreshInterval: this.timefilterRef.getRefreshInterval(),
      time: this.timefilterRef.getTime()
    };
    this.lastAssignedState = newState;
    this.stateContainer.set(newState);
  }
  getState() {
    const currentState = {
      ...this.lastAssignedState,
      ...this.stateContainer.get()
    };
    delete currentState.filters;
    const {
      refreshInterval: _nullA,
      time: _nullB,
      ...currentAppState
    } = currentState;
    return currentAppState || {};
  }
  destroy() {
    this.syncQueryStateWithUrlManager.stop();
    this.stateContainerChangeSub.unsubscribe();
    this.stateSyncRef.stop();
  }
}
exports.GlobalState = GlobalState;