"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardActivity = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _table = require("../../table");
var _recovery_index = require("./recovery_index");
var _total_time = require("./total_time");
var _source_destination = require("./source_destination");
var _progress = require("./progress");
var _parse_props = require("./parse_props");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/shard_activity/shard_activity.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columns = [{
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.indexTitle', {
    defaultMessage: 'Index'
  }),
  field: 'name',
  render: (_name, shard) => /*#__PURE__*/_react.default.createElement(_recovery_index.RecoveryIndex, (0, _extends2.default)({}, shard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 31
    }
  }))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.stageTitle', {
    defaultMessage: 'Stage'
  }),
  field: 'stage'
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.totalTimeTitle', {
    defaultMessage: 'Total Time'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_total_time.TotalTime, (0, _extends2.default)({}, shard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 24
    }
  }))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.sourceDestinationTitle', {
    defaultMessage: 'Source / Destination'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_source_destination.SourceDestination, (0, _extends2.default)({}, shard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 24
    }
  }))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.filesTitle', {
    defaultMessage: 'Files'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_progress.FilesProgress, (0, _extends2.default)({}, shard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 24
    }
  }))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.bytesTitle', {
    defaultMessage: 'Bytes'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_progress.BytesProgress, (0, _extends2.default)({}, shard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 24
    }
  }))
}, {
  name: _i18n.i18n.translate('xpack.monitoring.kibana.shardActivity.translogTitle', {
    defaultMessage: 'Translog'
  }),
  field: null,
  render: shard => /*#__PURE__*/_react.default.createElement(_progress.TranslogProgress, (0, _extends2.default)({}, shard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 24
    }
  }))
}];
const ShardActivity = props => {
  var _services$uiSettings;
  const {
    data: rawData,
    sorting,
    pagination,
    onTableChange,
    toggleShardActivityHistory,
    showShardActivityHistory
  } = props;
  const {
    services
  } = (0, _public.useKibana)();
  const timezone = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get('dateFormat:tz');
  const getNoDataMessage = () => {
    if (showShardActivityHistory) {
      return _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardActivity.noDataMessage', {
        defaultMessage: 'There are no historical shard activity records for the selected time range.'
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardActivity.noActiveShardRecoveriesMessage.completedRecoveriesLinkTextProblem",
      defaultMessage: "There are no active shard recoveries for this cluster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("br", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardActivity.noActiveShardRecoveriesMessage.completedRecoveriesLinkTextSolution",
      defaultMessage: "Try viewing {shardActivityHistoryLink}.",
      values: {
        shardActivityHistoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleShardActivityHistory,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.elasticsearch.shardActivity.noActiveShardRecoveriesMessage.completedRecoveriesLinkText",
          defaultMessage: "completed recoveries",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 17
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }));
  };
  const rows = rawData.map(data => (0, _parse_props.parseProps)({
    ...data,
    timezone
  }));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivityTitle",
    defaultMessage: "Shard Activity",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "monitoring_completed_recoveries",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.shardActivity.completedRecoveriesLabel",
      defaultMessage: "Completed recoveries",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }),
    onChange: toggleShardActivityHistory,
    checked: showShardActivityHistory,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    "data-test-subj": "esShardActivityTable",
    rows: rows,
    columns: columns,
    message: getNoDataMessage(),
    sorting: sorting,
    search: false,
    pagination: pagination,
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['name']
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
};
exports.ShardActivity = ShardActivity;