"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStashNodePipelinesPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _pipelines = require("../../../lib/logstash/pipelines");
var _global_state_context = require("../../contexts/global_state_context");
var _logstash_template = require("./logstash_template");
var _detail_status = require("../../../components/logstash/detail_status");
var _use_table = require("../../hooks/use_table");
var _pipeline_listing = require("../../../components/logstash/pipeline_listing/pipeline_listing");
var _use_charts = require("../../hooks/use_charts");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/logstash/node_pipelines.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogStashNodePipelinesPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const match = (0, _reactRouterDom.useRouteMatch)();
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const {
    onBrush,
    zoomInfo
  } = (0, _use_charts.useCharts)();
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const {
    getPaginationTableProps,
    getPaginationRouteOptions,
    updateTotalItemCount
  } = (0, _use_table.useTable)('logstash.pipelines');
  const [data, setData] = (0, _react.useState)({});
  const title = _i18n.i18n.translate('xpack.monitoring.logstash.node.pipelines.routeTitle', {
    defaultMessage: 'Logstash - {nodeName} - Pipelines',
    values: {
      nodeName: data.nodeSummary ? data.nodeSummary.name : ''
    }
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.logstash.node.pipelines.pageTitle', {
    defaultMessage: 'Logstash node pipelines: {nodeName}',
    values: {
      nodeName: data.nodeSummary ? data.nodeSummary.name : ''
    }
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/logstash/node/${match.params.uuid}/pipelines`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        },
        ...getPaginationRouteOptions()
      })
    }));
    setData(response);
    updateTotalItemCount(response.totalPipelineCount);
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, getPaginationRouteOptions, updateTotalItemCount, match.params.uuid]);
  (0, _react.useEffect)(() => {
    if (cluster && data.nodeSummary) {
      generateBreadcrumbs(cluster.cluster_name, {
        inLogstash: true,
        instance: data.nodeSummary.host,
        name: 'nodes'
      });
    }
  }, [cluster, data, generateBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_logstash_template.LogstashTemplate, {
    instance: data,
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    cluster: cluster,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, data.pipelines && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "logstashPipelinesListing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_listing.PipelineListing, (0, _extends2.default)({
    "data-test-subj": "monitoringLogstashPipelinesTable",
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    stats: data.nodeSummary,
    data: data.pipelines,
    statusComponent: _detail_status.DetailStatus
  }, getPaginationTableProps(), {
    upgradeMessage: makeUpgradeMessage(data.nodeSummary.version),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }))));
};
exports.LogStashNodePipelinesPage = LogStashNodePipelinesPage;
function makeUpgradeMessage(logstashVersions) {
  if (!Array.isArray(logstashVersions) || logstashVersions.length === 0 || logstashVersions.some(_pipelines.isPipelineMonitoringSupportedInVersion)) {
    return null;
  }
  return 'Pipeline monitoring is only available in Logstash version 6.0.0 or higher.';
}