"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.config = void 0;
var _config = require("./config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const plugin = async initContext => {
  const {
    MonitoringCollectionPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new MonitoringCollectionPlugin(initContext);
};
exports.plugin = plugin;
const config = exports.config = {
  schema: _config.configSchema,
  deprecations: ({
    unused
  }) => [
  // The logging of the OTel instrumentation is handled by core
  // https://github.com/elastic/kibana/blob/afb35a5f5e47c49a20c355b87239c731bf891931/src/core/packages/root/server-internal/src/root/index.ts#L142
  unused('opentelemetry.metrics.otlp.logLevel', {
    level: 'warning',
    message: 'This setting is unused. Please, configure the level via the loggers interface for the logger name "telemetry"',
    documentationUrl: 'https://www.elastic.co/docs/reference/kibana/configuration-reference/logging-settings'
  })]
};