"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newCalendarRouteFactory = exports.newCalendarDstRouteFactory = exports.editCalendarRouteFactory = exports.editCalendarDstRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
var _locator = require("../../../../../common/constants/locator");
var _ml_nodes_check = require("../../../ml_nodes_check");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/settings/calendar_new_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var MODE = /*#__PURE__*/function (MODE) {
  MODE[MODE["NEW"] = 0] = "NEW";
  MODE[MODE["EDIT"] = 1] = "EDIT";
  return MODE;
}(MODE || {});
const NewCalendar = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../settings/calendars')))).NewCalendar
}));
const newCalendarRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_NEW),
  title: _i18n.i18n.translate('xpack.ml.settings.createCalendar.docTitle', {
    defaultMessage: 'Create Calendar'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: MODE.NEW,
    isDst: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('CALENDAR_LISTS_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagement.createLabel', {
      defaultMessage: 'Create'
    })
  }]
});
exports.newCalendarRouteFactory = newCalendarRouteFactory;
const editCalendarRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_EDIT, '/:calendarId'),
  title: _i18n.i18n.translate('xpack.ml.settings.editCalendar.docTitle', {
    defaultMessage: 'Edit Calendar'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: MODE.EDIT,
    isDst: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('CALENDAR_LISTS_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagement.editLabel', {
      defaultMessage: 'Edit'
    })
  }]
});
exports.editCalendarRouteFactory = editCalendarRouteFactory;
const newCalendarDstRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_DST_NEW),
  title: _i18n.i18n.translate('xpack.ml.settings.createCalendarDst.docTitle', {
    defaultMessage: 'Create DST Calendar'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: MODE.NEW,
    isDst: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('CALENDAR_DST_LISTS_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagement.createLabel', {
      defaultMessage: 'Create'
    })
  }]
});
exports.newCalendarDstRouteFactory = newCalendarDstRouteFactory;
const editCalendarDstRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.CALENDARS_DST_EDIT, '/:calendarId'),
  title: _i18n.i18n.translate('xpack.ml.settings.editCalendarDst.docTitle', {
    defaultMessage: 'Edit DST Calendar'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    mode: MODE.EDIT,
    isDst: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('CALENDAR_DST_LISTS_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagement.editLabel', {
      defaultMessage: 'Edit'
    })
  }]
});
exports.editCalendarDstRouteFactory = editCalendarDstRouteFactory;
const PageWrapper = ({
  location,
  mode,
  isDst
}) => {
  let calendarId;
  if (mode === MODE.EDIT) {
    const pathMatch = location.pathname.match(/.+\/(.+)$/);
    calendarId = pathMatch && pathMatch.length > 1 ? pathMatch[1] : undefined;
  }
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    getMlNodeCount: _ml_nodes_check.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(NewCalendar, {
    calendarId: calendarId,
    isDst: isDst,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }));
};