"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestDfaModelsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _test_pipeline = require("../components/ml_inference/components/test_pipeline");
var _state = require("../components/ml_inference/state");
var _types = require("../components/ml_inference/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_dfa_models_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TestDfaModelsFlyout = ({
  model,
  onClose
}) => {
  const sourceIndex = (0, _react.useMemo)(() => {
    var _model$metadata, _model$metadata2, _model$metadata3;
    return Array.isArray((_model$metadata = model.metadata) === null || _model$metadata === void 0 ? void 0 : _model$metadata.analytics_config.source.index) ? (_model$metadata2 = model.metadata) === null || _model$metadata2 === void 0 ? void 0 : _model$metadata2.analytics_config.source.index.join() : (_model$metadata3 = model.metadata) === null || _model$metadata3 === void 0 ? void 0 : _model$metadata3.analytics_config.source.index;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model === null || model === void 0 ? void 0 : model.model_id]);
  const state = (0, _react.useMemo)(() => (0, _state.getInitialState)(model),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model === null || model === void 0 ? void 0 : model.model_id]);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'mlTestModelsFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "l",
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    "data-test-subj": "mlTestModelsFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testDfaModelsFlyout.headerLabel",
    defaultMessage: "Test trained model",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, model.model_id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_test_pipeline.TestPipeline, {
    state: state,
    sourceIndex: sourceIndex,
    mode: _types.TEST_PIPELINE_MODE.STAND_ALONE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })));
};
exports.TestDfaModelsFlyout = TestDfaModelsFlyout;