"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyTableStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _severity_format_resolver = require("../components/controls/select_severity/severity_format_resolver");
var _explorer_utils = require("./explorer_utils");
var _search = require("../../../common/constants/search");
var _explorer_constants = require("./explorer_constants");
var _job_utils = require("../../../common/util/job_utils");
var _state_service = require("../services/state_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnomalyTableStateService extends _state_service.StateService {
  constructor(mlApi, mlJobService, uiSettings, timefilter, anomalyExplorerCommonStateService, anomalyTimelineStateService, tableSeverityUrlStateService, tableIntervalUrlStateService) {
    super();
    (0, _defineProperty2.default)(this, "_tableData$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "_tableDataLoading$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "_tableError$", new _rxjs.BehaviorSubject(null));
    (0, _defineProperty2.default)(this, "_timeBounds$", void 0);
    (0, _defineProperty2.default)(this, "_refreshSubject$", void 0);
    (0, _defineProperty2.default)(this, "tableData$", this._tableData$.asObservable());
    (0, _defineProperty2.default)(this, "tableDataLoading$", this._tableDataLoading$.asObservable());
    (0, _defineProperty2.default)(this, "tableError$", this._tableError$.asObservable());
    this.mlApi = mlApi;
    this.mlJobService = mlJobService;
    this.uiSettings = uiSettings;
    this.timefilter = timefilter;
    this.anomalyExplorerCommonStateService = anomalyExplorerCommonStateService;
    this.anomalyTimelineStateService = anomalyTimelineStateService;
    this.tableSeverityUrlStateService = tableSeverityUrlStateService;
    this.tableIntervalUrlStateService = tableIntervalUrlStateService;
    this._timeBounds$ = this.timefilter.getTimeUpdate$().pipe((0, _rxjs.startWith)(null), (0, _rxjs.map)(() => this.timefilter.getBounds()));
    this._refreshSubject$ = _mlDatePicker.mlTimefilterRefresh$.pipe((0, _rxjs.startWith)({
      lastRefresh: 0
    }));
    this._init();
  }
  get tableData() {
    return this._tableData$.getValue();
  }
  get tableDataLoading() {
    return this._tableDataLoading$.getValue();
  }
  get tableError() {
    return this._tableError$.getValue();
  }
  _initSubscriptions() {
    const subscriptions = new _rxjs.Subscription();

    // Add the main subscription that updates tableData$
    subscriptions.add((0, _rxjs.combineLatest)([this.anomalyTimelineStateService.getSelectedCells$(), this.anomalyExplorerCommonStateService.selectedJobs$, this.anomalyTimelineStateService.getViewBySwimlaneFieldName$(), this.tableIntervalUrlStateService.getUrlState$(), this.tableSeverityUrlStateService.getUrlState$(), this.anomalyExplorerCommonStateService.influencerFilterQuery$, this._refreshSubject$, this._timeBounds$]).pipe((0, _rxjs.distinctUntilChanged)((prev, curr) => (0, _lodash.isEqual)(prev, curr)), (0, _rxjs.skipWhile)(([selectedCells, selectedJobs, viewBySwimlaneFieldName]) => selectedCells === undefined || !selectedJobs || selectedJobs.length === 0 || viewBySwimlaneFieldName === undefined), (0, _rxjs.tap)(() => this._tableDataLoading$.next(true)), (0, _rxjs.switchMap)(([selectedCells, selectedJobs, viewBySwimlaneFieldName, tableInterval, tableSeverity, influencersFilterQuery]) => {
      // Resolve the severity format in case it's in the old format
      const resolvedSeverity = (0, _severity_format_resolver.resolveSeverityFormat)(tableSeverity.val);

      // Clear previous error before starting a new load cycle
      this._tableError$.next(null);
      return this.loadAnomaliesTableData(selectedCells, selectedJobs,
      // viewBySwimlaneFieldName is guaranteed to be defined by the skipWhile
      viewBySwimlaneFieldName, tableInterval.val, resolvedSeverity, influencersFilterQuery).pipe((0, _rxjs.map)(tableData => ({
        tableData,
        tableDataLoading: false
      })), (0, _rxjs.catchError)(error => {
        const message = (0, _mlErrorUtils.extractErrorMessage)(error);
        this._tableError$.next(message);
        return (0, _rxjs.of)({
          tableData: null,
          tableDataLoading: false
        });
      }));
    })).subscribe(result => {
      // Update the BehaviorSubject with new data
      this._tableData$.next(result.tableData);
      this._tableDataLoading$.next(false);
    }));
    return subscriptions;
  }
  loadAnomaliesTableData(selectedCells, selectedJobs, fieldName, tableInterval, tableSeverity, influencersFilterQuery) {
    const jobIds = (0, _explorer_utils.getSelectionJobIds)(selectedCells, selectedJobs);
    const influencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, fieldName);
    const bounds = this.timefilter.getBounds();
    const timeRange = (0, _explorer_utils.getSelectionTimeRange)(selectedCells, bounds);
    const dateFormatTz = (0, _explorer_utils.getDateFormatTz)(this.uiSettings);
    return this.mlApi.results.getAnomaliesTableData(jobIds, [], influencers, tableInterval, tableSeverity, timeRange.earliestMs, timeRange.latestMs, dateFormatTz, _search.ANOMALIES_TABLE_DEFAULT_QUERY_SIZE, _explorer_constants.MAX_CATEGORY_EXAMPLES, influencersFilterQuery).pipe((0, _rxjs.map)(resp => {
      var _resp$examplesByJobId;
      const detectorsByJob = this.mlJobService.detectorsByJob;
      const anomalies = resp.anomalies.map(anomaly => {
        const jobId = anomaly.jobId;
        const detector = (0, _lodash.get)(detectorsByJob, [jobId, anomaly.detectorIndex]);
        const extendedAnomaly = {
          ...anomaly
        };
        extendedAnomaly.detector = (0, _lodash.get)(detector, ['detector_description'], anomaly.source.function_description);
        if (detector !== undefined && detector.custom_rules !== undefined) {
          extendedAnomaly.rulesLength = detector.custom_rules.length;
        }
        const job = this.mlJobService.getJob(jobId);
        let isChartable = (0, _job_utils.isSourceDataChartableForDetector)(job, anomaly.detectorIndex);
        if (isChartable === false && (0, _job_utils.isModelPlotChartableForDetector)(job, anomaly.detectorIndex)) {
          const entityFields = (0, _mlAnomalyUtils.getEntityFieldList)(anomaly.source);
          isChartable = (0, _job_utils.isModelPlotEnabled)(job, anomaly.detectorIndex, entityFields);
        }
        extendedAnomaly.isTimeSeriesViewRecord = isChartable;
        extendedAnomaly.isGeoRecord = detector !== undefined && detector.function === _mlAnomalyUtils.ML_JOB_AGGREGATION.LAT_LONG;
        if (this.mlJobService.customUrlsByJob[jobId] !== undefined) {
          extendedAnomaly.customUrls = this.mlJobService.customUrlsByJob[jobId];
        }
        return extendedAnomaly;
      });
      return {
        anomalies,
        interval: resp.interval,
        examplesByJobId: (_resp$examplesByJobId = resp.examplesByJobId) !== null && _resp$examplesByJobId !== void 0 ? _resp$examplesByJobId : {},
        showViewSeriesLink: true,
        jobIds
      };
    }));
  }
}
exports.AnomalyTableStateService = AnomalyTableStateService;