"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataFrameAnalyticsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _common = require("../../../../common");
var _common2 = require("./common");
var _analytics_service = require("../../services/analytics_service");
var _use_columns = require("./use_columns");
var _expanded_row = require("./expanded_row");
var _stats_bar = require("../../../../../components/stats_bar");
var _search_bar_filters = require("../../../../common/search_bar_filters");
var _empty_prompt = require("../empty_prompt");
var _use_table_settings = require("./use_table_settings");
var _jobs_awaiting_node_warning = require("../../../../../components/jobs_awaiting_node_warning");
var _use_refresh = require("../../../../../routing/use_refresh");
var _space_management_context_wrapper = require("../../../../../components/space_management_context_wrapper");
var _date_picker = require("../../../../../components/ml_page/date_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/analytics_list/analytics_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const filters = [{
  type: 'field_value_selection',
  field: 'job_type',
  name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.typeFilter', {
    defaultMessage: 'Type'
  }),
  multiSelect: 'or',
  options: Object.values(_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE).map(val => ({
    value: val,
    name: val,
    view: (0, _use_columns.getJobTypeBadge)(val)
  }))
}, {
  type: 'field_value_selection',
  field: 'state',
  name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.statusFilter', {
    defaultMessage: 'Status'
  }),
  multiSelect: 'or',
  options: Object.values(_mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE).map(val => ({
    value: val,
    name: val,
    view: (0, _use_columns.getTaskStateBadge)(val)
  }))
}];
function getItemIdToExpandedRowMap(itemIds, dataFrameAnalytics) {
  return itemIds.reduce((m, analyticsId) => {
    const item = dataFrameAnalytics.find(analytics => analytics.config.id === analyticsId);
    if (item !== undefined) {
      m[analyticsId] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        item: item,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 24
        }
      });
    }
    return m;
  }, {});
}
const DataFrameAnalyticsList = ({
  isMlEnabledInSpace = true,
  blockRefresh = false,
  pageState,
  updatePageState
}) => {
  var _pageState$queryText;
  const searchQueryText = (_pageState$queryText = pageState.queryText) !== null && _pageState$queryText !== void 0 ? _pageState$queryText : '';
  const setSearchQueryText = (0, _react.useCallback)(value => {
    updatePageState({
      queryText: value
    });
  }, [updatePageState]);
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [filteredAnalytics, setFilteredAnalytics] = (0, _react.useState)([]);
  const [searchError, setSearchError] = (0, _react.useState)();
  const [analytics, setAnalytics] = (0, _react.useState)([]);
  const [analyticsStats, setAnalyticsStats] = (0, _react.useState)(undefined);
  const [expandedRowItemIds, setExpandedRowItemIds] = (0, _react.useState)([]);
  const [errorMessage, setErrorMessage] = (0, _react.useState)(undefined);
  const [jobsAwaitingNodeCount, setJobsAwaitingNodeCount] = (0, _react.useState)(0);
  const refreshObs = (0, _use_refresh.useRefresh)();
  const getAnalytics = (0, _analytics_service.useGetAnalytics)(setAnalytics, setAnalyticsStats, setErrorMessage, setIsInitialized, setJobsAwaitingNodeCount, blockRefresh);
  const updateFilteredItems = (0, _react.useCallback)(queryClauses => {
    if (queryClauses.length) {
      const filtered = (0, _search_bar_filters.filterAnalytics)(analytics, queryClauses);
      setFilteredAnalytics(filtered);
    } else {
      setFilteredAnalytics(analytics);
    }
  }, [analytics]);
  const filterList = () => {
    if (searchQueryText !== '') {
      // trigger table filtering with query for job id to trigger table filter
      const query = _eui.EuiSearchBar.Query.parse(searchQueryText);
      let clauses = [];
      if (query && query.ast !== undefined && query.ast.clauses !== undefined) {
        clauses = query.ast.clauses;
      }
      updateFilteredItems(clauses);
    } else {
      updateFilteredItems([]);
    }
  };
  (0, _react.useEffect)(() => {
    filterList();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [searchQueryText]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const getAnalyticsCallback = (0, _react.useCallback)(() => getAnalytics(true), []);

  // Subscribe to the refresh observable to trigger reloading the analytics list.
  const {
    refresh
  } = (0, _common.useRefreshAnalyticsList)({
    isLoading: setIsLoading,
    onRefresh: getAnalyticsCallback
  });
  (0, _react.useEffect)(function updateOnTimerRefresh() {
    getAnalyticsCallback();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [refreshObs]);
  const {
    columns,
    modals
  } = (0, _use_columns.useColumns)(expandedRowItemIds, setExpandedRowItemIds, isMlEnabledInSpace, refresh);
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _use_table_settings.useTableSettings)(filteredAnalytics.length, pageState, updatePageState);
  const handleSearchOnChange = search => {
    if (search.error !== null) {
      setSearchError(search.error.message);
      return;
    }
    setSearchError(undefined);
    setSearchQueryText(search.queryText);
  };

  // Before the analytics have been loaded for the first time, display the loading indicator only.
  // Otherwise a user would see 'No data frame analytics found' during the initial loading.
  if (!isInitialized) {
    return null;
  }
  if (typeof errorMessage !== 'undefined') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.errorPromptTitle', {
        defaultMessage: 'An error occurred getting the data frame analytics list.'
      }),
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("pre", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 9
      }
    }, JSON.stringify(errorMessage)));
  }
  if (analytics.length === 0) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlAnalyticsJobList",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_empty_prompt.AnalyticsEmptyPrompt, {
      showDocsLink: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 9
      }
    }));
  }
  const itemIdToExpandedRowMap = getItemIdToExpandedRowMap(expandedRowItemIds, analytics);
  const stats = analyticsStats && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: analyticsStats,
    dataTestSub: 'mlAnalyticsStatsBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }));
  const search = {
    query: searchQueryText,
    onChange: handleSearchOnChange,
    box: {
      incremental: true
    },
    filters
  };
  return /*#__PURE__*/_react.default.createElement(_space_management_context_wrapper.SpaceManagementContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsJobList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }, modals, /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.JobsAwaitingNodeWarning, {
    jobCount: jobsAwaitingNodeCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }, stats, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_date_picker.DatePicker, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsTableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    rowHeader: _common2.DataFrameAnalyticsListColumn.id,
    allowNeutralSort: false,
    columns: columns,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    items: analytics,
    itemId: _common2.DataFrameAnalyticsListColumn.id,
    loading: isLoading,
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    search: search,
    "data-test-subj": isLoading ? 'mlAnalyticsTable loading' : 'mlAnalyticsTable loaded',
    rowProps: item => ({
      'data-test-subj': `mlAnalyticsTableRow row-${item.id}`
    }),
    error: searchError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 11
    }
  }))));
};
exports.DataFrameAnalyticsList = DataFrameAnalyticsList;