"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricsExperienceClient = createMetricsExperienceClient;
var _serverRouteRepositoryClient = require("@kbn/server-route-repository-client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createMetricsExperienceClient(core) {
  const request = (0, _serverRouteRepositoryClient.createRepositoryClient)(core).fetch;
  return {
    getDimensions: (params, signal) => request('GET /internal/metrics_experience/dimensions', {
      params: {
        query: params
      },
      signal
    }),
    getFields: (params, signal) => request('GET /internal/metrics_experience/fields', {
      params: {
        query: params
      },
      signal
    }),
    getIndexPatternMetadata({
      indexPattern,
      from,
      to
    }, signal) {
      return request('GET /internal/metrics_experience/index_pattern_metadata/{indexPattern}', {
        params: {
          path: {
            indexPattern
          },
          query: {
            from,
            to
          }
        },
        signal
      });
    }
  };
}